package com.biz.crm.mdm.business.material.sdk.event;


import com.biz.crm.mdm.business.material.sdk.vo.MaterialEventVo;
import com.bizunited.nebula.event.sdk.service.NebulaEvent;

/**
 * MaterialEventListener 物料数据操作事件通知
 *
 * @author pengxi
 */
public interface MaterialEventListener extends NebulaEvent {

  /**
   * 当删除时，触发事件
   *
   * @param materialEventVo
   * @return
   */
  default void onDelete(MaterialEventVo materialEventVo) { }

  /**
   * 当启用时，触发事件
   *
   * @param materialEventVo
   * @return
   */
  default void onEnable(MaterialEventVo materialEventVo){ }

  /**
   * 当禁用时，触发事件
   *
   * @param materialEventVo
   * @return
   */
  default void onDisable(MaterialEventVo materialEventVo){ }

  /**
   * 当修改时，触发事件
   *
   * @param materialEventVo
   * @return
   */
  default void onChange(MaterialEventVo materialEventVo){ }

  /**
   * 当新建时，触发事件
   *
   * @param materialEventVo
   * @return
   */
  default void onCreate(MaterialEventVo materialEventVo){ }
}
