package com.biz.crm.mdm.business.material.unit.dataview;

import org.springframework.stereotype.Component;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;

/**
 * @author HanJiaJun
 * @describe:MDM单位管理数据视图
 * @createTime 2022年09月13日 16:58:00
 */
@Component
public class MaterialUnitDataviewRegister implements DataviewRegister {
  @Override
  public String code() {
    return "mdm_material_unit_dataview";
  }

  @Override
  public String desc() {
    return "MDM单位管理数据视图";
  }

  @Override
  public String buildSql() {
    return "SELECT unitType.*,  " +
            " mp.product_name " +
            " FROM material_unit_type unitType " +
            " left join mdm_product mp on unitType.unit_type_code = mp.product_code" +
            " WHERE unitType.del_flag = '"+ DelFlagStatusEnum.NORMAL.getCode() +"' " +
            " and mp.del_flag = '"+ DelFlagStatusEnum.NORMAL.getCode() +"' " +
            " and unitType.tenant_code = :tenantCode "+
            " and mp.tenant_code = :tenantCode " ;

//    return "SELECT t.*  FROM material_unit_type t" +
//            "  WHERE  t.del_flag = '" + DelFlagStatusEnum.NORMAL.getCode() + "' " +
//            "  AND t.tenant_code = :tenantCode ";
  }
}
