package com.biz.crm.mdm.business.material.unit.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * @author jerry7
 * @date 2021/10/26 16:24
 * 物料单位实体类
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MaterialUnit", description = "物料单位实体类")
@Entity
@org.hibernate.annotations.Table(appliesTo = "`material_unit`", comment = "物料单位实体类")
@TableName("material_unit")
@Table(name = "`material_unit`", indexes = @Index(name = "material_unit_idx", columnList = "unit_type_code", unique = false))
public class MaterialUnit extends TenantFlagOpEntity {
  private static final long serialVersionUID = 8599246341788262253L;

  /**
   * 物料单位编码
   */
  @ApiModelProperty("物料单位编码")
  @Column(name = "unit_code", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 物料单位编码 '")
  private String unitCode;

  /**
   * 物料单位名称
   */
  @ApiModelProperty("物料单位名称")
  @Column(name = "unit_name", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 物料单位名称 '")
  private String unitName;


  /**
   * 物料单位类型编码
   */
  @ApiModelProperty("物料单位类型编码")
  @Column(name = "unit_type_code", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 物料单位类型编码 '")
  private String unitTypeCode;

  /**
   * 物料单位换算系数
   */
  @ApiModelProperty("物料单位换算系数")
  @Column(name = "convert_scale", precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT ' 换算系数 '")
  private BigDecimal convertScale;

  /**
   * EA单位换算系数
   */
  @ApiModelProperty("EA单位换算系数")
  @Column(name = "measure_convert_scale", precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT ' EA单位换算系数 '")
  private BigDecimal measureConvertScale;

  /**
   * 是否标准单位标准(Y/N)
   */
  @ApiModelProperty("是否标准单位标准(Y/N)")
  @Column(name = "standard_unit_flag", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 是否标准单位标准(Y/N) '")
  private String standardUnitFlag;

  /**
   * 标准物料单位编码
   */
  @ApiModelProperty("标准物料单位编码")
  @Column(name = "standard_unit_code", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 标准物料单位编码 '")
  private String standardUnitCode;
}
