package com.biz.crm.mdm.business.material.unit.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.material.unit.dto.MaterialUnitTypeDto;
import com.biz.crm.mdm.business.material.unit.entity.MaterialUnitType;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 物料单位类型 的 mybatis-plus接口类 {@link MaterialUnitType}
 *
 * @author jerry7
 */
public interface MaterialUnitTypeMapper extends BaseMapper<MaterialUnitType> {

  /**
   * 分页列表
   *
   * @param page 分页信息
   * @param dto  分页参数dto
   * @return 分页列表
   */
  Page<MaterialUnitType> findByConditions(Page<MaterialUnitType> page, @Param("dto") MaterialUnitTypeDto dto);


  /**
   * 根据id查询物料单位类别详情(包含物料单位类别下的物料单位)
   * @param id 主键
   * @param tenantCode 租户编号
   * @return 物料单位实体
   */
  MaterialUnitType findDetailById(String id, String tenantCode);

  /**
   * 根据物料单位类别编码查询物料单位类别详情(包含物料单位类别下的物料单位)
   * 
   * @param unitTypeCode 主键
   * @param tenantCode 租户编号
   * @return 物料单位实体
   */
  MaterialUnitType findDetailByUnitTypeCode(String unitTypeCode, String tenantCode);
  
  /**
   * 条件查询物料单位类型(包含下级单位列表)
   *
   * @param dto 查询筛选条件
   * @return 数据
   */
  List<MaterialUnitType> findDetailsByConditions(@Param("dto") MaterialUnitTypeDto dto);


}
