/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.material.unit.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.material.unit.dto.MaterialUnitDto;
import com.biz.crm.mdm.business.material.unit.entity.MaterialUnit;
import com.biz.crm.mdm.business.material.unit.mapper.MaterialUnitMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class MaterialUnitRepository
extends ServiceImpl<MaterialUnitMapper, MaterialUnit> {
    @Autowired(required=false)
    private MaterialUnitMapper materialUnitMapper;

    public Page<MaterialUnit> findByConditions(Page<MaterialUnit> pageable, MaterialUnitDto dto) {
        dto.setTenantCode(TenantUtils.getTenantCode());
        return ((MaterialUnitMapper)this.baseMapper).findByConditions(pageable, dto);
    }

    public MaterialUnit findByUnitCode(String unitCode) {
        return (MaterialUnit)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MaterialUnit::getUnitCode, (Object)unitCode)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).one());
    }

    public List<MaterialUnit> findByUnitTypeCode(String unitTypeCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MaterialUnit::getUnitTypeCode, (Object)unitTypeCode)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).list();
    }

    public void updateEnableStatusByIdIn(EnableStatusEnum enable, List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).set(UuidFlagOpEntity::getEnableStatus, (Object)enable.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).update();
    }

    public void updateDelStatusByIdIn(DelFlagStatusEnum delFlagStatusEnum, List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).set(UuidFlagOpEntity::getDelFlag, (Object)delFlagStatusEnum.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).update();
    }

    public void updateDelStatusByUnitType(DelFlagStatusEnum delFlagStatusEnum, String unitTypeCode, List<String> unitCodes) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MaterialUnit::getUnitTypeCode, (Object)unitTypeCode)).notIn(MaterialUnit::getUnitCode, unitCodes)).set(UuidFlagOpEntity::getDelFlag, (Object)delFlagStatusEnum.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).update();
    }

    public MaterialUnit findByIdAndTenantCode(String id, String tenantCode) {
        return (MaterialUnit)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).in(UuidEntity::getId, new Object[]{id})).one());
    }

    public List<MaterialUnit> listByUnitTypeCodes(List<String> unitTypeCodeList) {
        if (CollectionUtils.isEmpty(unitTypeCodeList)) {
            return null;
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(MaterialUnit::getUnitTypeCode, unitTypeCodeList)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public List<MaterialUnit> findByMaterialUnitCodeAllLists(List<String> unitCodeList) {
        if (CollectionUtils.isEmpty(unitCodeList)) {
            return null;
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(MaterialUnit::getUnitTypeCode, unitCodeList)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public List<MaterialUnit> findByUnitCodes(List<String> unitCode) {
        return ((LambdaQueryChainWrapper)this.lambdaQuery().in(MaterialUnit::getUnitTypeCode, unitCode)).list();
    }

    public void deleteBatchMaterialUnit(List<String> collectUnitTypeCode) {
        if (CollectionUtils.isEmpty(collectUnitTypeCode)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(MaterialUnit::getUnitTypeCode, collectUnitTypeCode)).remove();
    }
}

