/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.material.unit.service.internal;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mdm.business.material.unit.dto.MaterialUnitDto;
import com.biz.crm.mdm.business.material.unit.entity.MaterialUnit;
import com.biz.crm.mdm.business.material.unit.entity.MaterialUnitType;
import com.biz.crm.mdm.business.material.unit.repository.MaterialUnitRepository;
import com.biz.crm.mdm.business.material.unit.repository.MaterialUnitTypeRepository;
import com.biz.crm.mdm.business.material.unit.service.MaterialUnitService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.dto.MasterDataMdgBaseDto;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.service.MasterDataMdgService;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.vo.MasterDataMdgMaterialUnitVo;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class MaterialUnitServiceImpl
implements MaterialUnitService {
    private static final Logger log = LoggerFactory.getLogger(MaterialUnitServiceImpl.class);
    @Autowired(required=false)
    private MaterialUnitRepository materialUnitRepository;
    @Autowired(required=false)
    private MaterialUnitTypeRepository materialUnitTypeRepository;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private RedisMutexService redisMutexService;
    @Autowired(required=false)
    private MasterDataMdgService masterDataMdgService;
    @Autowired(required=false)
    private DictToolkitService dictToolkitService;

    @Override
    public Page<MaterialUnit> findByConditions(Pageable pageable, MaterialUnitDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        dto = Optional.ofNullable(dto).orElse(new MaterialUnitDto());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.materialUnitRepository.findByConditions((Page<MaterialUnit>)page, dto);
    }

    @Override
    @Transactional
    public void enableBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u5f85\u4fee\u6b63\u7684\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.materialUnitRepository.updateEnableStatusByIdIn(EnableStatusEnum.ENABLE, ids);
    }

    @Override
    @Transactional
    public void disableBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u5f85\u4fee\u6b63\u7684\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.materialUnitRepository.updateEnableStatusByIdIn(EnableStatusEnum.DISABLE, ids);
    }

    @Override
    @Transactional
    public void deleteBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u5f85\u4fee\u6b63\u7684\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.materialUnitRepository.updateDelStatusByIdIn(DelFlagStatusEnum.DELETE, ids);
    }

    @Override
    public void deleteByUnitTypeCode(String unitTypeCode, List<String> unitCodes) {
        Validate.notNull((Object)unitTypeCode, (String)"\u5f85\u4fee\u6b63\u7684\u7269\u6599\u5355\u4f4d\u7c7b\u522b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.materialUnitRepository.updateDelStatusByUnitType(DelFlagStatusEnum.DELETE, unitTypeCode, unitCodes);
    }

    @Override
    public MaterialUnit findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.materialUnitRepository.findByIdAndTenantCode(id, TenantUtils.getTenantCode());
    }

    @Override
    public List<MaterialUnit> findByUnitTypeCode(String unitTypeCode) {
        return this.materialUnitRepository.findByUnitTypeCode(unitTypeCode);
    }

    @Override
    @Transactional
    public MaterialUnit create(MaterialUnit materialUnit) {
        Validate.notNull((Object)((Object)materialUnit), (String)"\u521b\u5efa\u767b\u5f55\u914d\u7f6e\u5b9e\u4f53\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.createValidate(materialUnit);
        materialUnit.setCreateTime(new Date());
        if (StringUtils.isBlank((CharSequence)materialUnit.getEnableStatus())) {
            materialUnit.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        }
        materialUnit.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        materialUnit.setTenantCode(TenantUtils.getTenantCode());
        materialUnit.setCreateAccount(this.loginUserService.getLoginAccountName());
        this.materialUnitRepository.saveOrUpdate((Object)materialUnit);
        return materialUnit;
    }

    @Override
    @Transactional
    public MaterialUnit update(MaterialUnit materialUnit) {
        Validate.notNull((Object)((Object)materialUnit), (String)"\u66f4\u65b0\u767b\u5f55\u914d\u7f6e\u5b9e\u4f53\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)materialUnit.getId(), (String)"\u767b\u5f55\u767b\u5f55\u914d\u7f6eID\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.createValidate(materialUnit);
        materialUnit.setModifyTime(new Date());
        materialUnit.setModifyAccount(this.loginUserService.getLoginAccountName());
        materialUnit.setTenantCode(TenantUtils.getTenantCode());
        this.materialUnitRepository.saveOrUpdate((Object)materialUnit);
        return materialUnit;
    }

    @Override
    public List<MaterialUnit> listByUnitTypeCodes(List<String> unitTypeCodeList) {
        if (CollectionUtils.isEmpty(unitTypeCodeList)) {
            return null;
        }
        return this.materialUnitRepository.listByUnitTypeCodes(unitTypeCodeList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pullMaterialUnitList(MasterDataMdgBaseDto dto) {
        String lockKey;
        if (ObjectUtils.isEmpty((Object)dto)) {
            dto = new MasterDataMdgBaseDto();
        }
        if (StringUtils.isEmpty((CharSequence)dto.getPageNum())) {
            dto.setPageNum("1");
        }
        if (StringUtils.isEmpty((CharSequence)dto.getPageSize())) {
            dto.setPageSize("400");
        }
        if (StringUtils.isEmpty((CharSequence)(lockKey = DateUtil.format((Date)new Date(), (String)"yyyyMMdd")))) {
            dto.setDs(lockKey);
        }
        boolean lock = true;
        try {
            lock = this.lock(lockKey);
            if (!lock) {
                return;
            }
            ArrayList<MaterialUnit> materialUnitList = new ArrayList<MaterialUnit>();
            ArrayList<MaterialUnitType> materialUnitTypeList = new ArrayList<MaterialUnitType>();
            ArrayList saveListMaterialUnit = new ArrayList();
            ArrayList updateListMaterialUnit = new ArrayList();
            ArrayList<MaterialUnitType> saveList = new ArrayList<MaterialUnitType>();
            ArrayList<MaterialUnitType> updateList = new ArrayList<MaterialUnitType>();
            ArrayList<String> unitTypeCode = new ArrayList();
            ArrayList<MasterDataMdgMaterialUnitVo> masterDataMdgMaterialUnitVos = new ArrayList();
            List<Object> byUnitTypeCodes = new ArrayList();
            List<Object> byUnitCode = new ArrayList();
            HashMap materialUnitTypeMap = new HashMap();
            HashMap materialUnitMap = new HashMap();
            ArrayList failList = new ArrayList();
            HashMap<String, String> codeMap = new HashMap<String, String>(10000);
            AtomicReference<MaterialUnitType> materialUnitTypeEntity = new AtomicReference<MaterialUnitType>(new MaterialUnitType());
            int maxPage = 0;
            maxPage = BooleanEnum.TRUE.getCapital().equals(dto.getFullPullFlag()) ? this.countPageMax(dto) : Integer.parseInt(dto.getPageNum());
            Map unitConvertMap = this.dictToolkitService.findConvertMapByDictTypeCode("material_base_unit");
            for (int pageNum = Integer.parseInt(dto.getPageNum()); pageNum <= maxPage; ++pageNum) {
                dto.setPageNum(Integer.toString(pageNum));
                masterDataMdgMaterialUnitVos = this.masterDataMdgService.pullMaterialUnitList(dto);
                if (CollectionUtils.isEmpty(masterDataMdgMaterialUnitVos)) {
                    return;
                }
                this.unitCodeValidate(masterDataMdgMaterialUnitVos, materialUnitList, materialUnitTypeList, codeMap, unitConvertMap);
                log.info("\u5f53\u524d\u62c9\u53d6\u8fdb\u5ea6\uff1a" + pageNum + "/" + maxPage + "\uff0c\u6bcf\u9875" + dto.getPageSize() + " \u6761\u6570\u636e\uff0c\u62c9\u53d6\u5931\u8d25\u7684\u6570\u636e\u5171" + failList.size() + "\u6761\uff0c---------------------------->" + JSON.toJSONString(failList));
                failList.clear();
                unitTypeCode = materialUnitTypeList.stream().map(MaterialUnitType::getUnitTypeCode).collect(Collectors.toList());
                byUnitTypeCodes = this.materialUnitTypeRepository.findByUnitTypeCodes(unitTypeCode);
                byUnitCode = this.materialUnitRepository.findByUnitCodes(unitTypeCode);
                if (CollectionUtils.isEmpty(byUnitTypeCodes)) {
                    this.saveOrUpdateBatchMaterialUnitType(materialUnitTypeList, null);
                    materialUnitTypeList.clear();
                }
                if (CollectionUtils.isEmpty(byUnitCode)) {
                    this.saveOrUpdateBatchMaterialUnit(materialUnitList, null);
                    materialUnitList.clear();
                }
                if (org.apache.commons.collections.CollectionUtils.isEmpty(materialUnitTypeList) && org.apache.commons.collections.CollectionUtils.isEmpty(materialUnitList)) {
                    return;
                }
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty(byUnitTypeCodes)) {
                    materialUnitTypeMap.putAll(byUnitTypeCodes.stream().collect(Collectors.toMap(MaterialUnitType::getUnitTypeCode, Function.identity())));
                    materialUnitTypeList.forEach(materialUnitType -> {
                        if (materialUnitTypeMap.containsKey(materialUnitType.getUnitTypeCode())) {
                            materialUnitTypeEntity.set((MaterialUnitType)((Object)materialUnitTypeMap.get(materialUnitType.getUnitTypeCode())));
                            materialUnitType.setId(((MaterialUnitType)((Object)((Object)materialUnitTypeEntity.get()))).getId());
                            materialUnitType.setEnableStatus(((MaterialUnitType)((Object)((Object)materialUnitTypeEntity.get()))).getEnableStatus());
                            updateList.add((MaterialUnitType)((Object)materialUnitType));
                        } else {
                            saveList.add((MaterialUnitType)((Object)materialUnitType));
                        }
                    });
                    this.saveOrUpdateBatchMaterialUnitType(saveList, updateList);
                    saveList.clear();
                    updateList.clear();
                    materialUnitTypeList.clear();
                    materialUnitTypeMap.clear();
                }
                this.saveOrUpdateBatchMaterialUnit(materialUnitList, null);
                saveListMaterialUnit.clear();
                updateListMaterialUnit.clear();
                materialUnitList.clear();
                materialUnitMap.clear();
            }
        }
        finally {
            if (lock) {
                this.unLock(lockKey);
            }
        }
    }

    private int countPageMax(MasterDataMdgBaseDto dto) {
        Integer totalNum = this.masterDataMdgService.countList("/mdg_materialUnit_tpm");
        int maxPage = 1;
        int sizeInt = Integer.parseInt(dto.getPageSize());
        if (totalNum > sizeInt) {
            maxPage = totalNum % sizeInt > 0 ? totalNum / sizeInt + 1 : totalNum / sizeInt;
        }
        return maxPage;
    }

    @Transactional(rollbackFor={Exception.class})
    void saveOrUpdateBatchMaterialUnitType(List<MaterialUnitType> saveList, List<MaterialUnitType> updateList) {
        if (!CollectionUtils.isEmpty(saveList)) {
            this.materialUnitTypeRepository.saveBatch(saveList);
        }
        if (!CollectionUtils.isEmpty(updateList)) {
            this.materialUnitTypeRepository.updateBatchById(updateList);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void saveOrUpdateBatchMaterialUnit(List<MaterialUnit> saveListMaterialUnit, List<MaterialUnit> updateListMaterialUnit) {
        List<String> collectUnitTypeCode = saveListMaterialUnit.stream().map(MaterialUnit::getUnitTypeCode).collect(Collectors.toList());
        this.materialUnitRepository.deleteBatchMaterialUnit(collectUnitTypeCode);
        if (!CollectionUtils.isEmpty(saveListMaterialUnit)) {
            this.materialUnitRepository.saveBatch(saveListMaterialUnit);
        }
    }

    private void unLock(String yearMonthDay) {
        if (StringUtils.isEmpty((CharSequence)yearMonthDay)) {
            throw new RuntimeException("\u62c9\u53d6\u4f9b\u5e94\u5546\u89e3\u9501\u5931\u8d25\uff0c\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        this.redisMutexService.unlock("materialUnit_lock:lock:" + yearMonthDay);
    }

    private void unitCodeValidate(List<MasterDataMdgMaterialUnitVo> masterDataMdgUnitTypeVos, List<MaterialUnit> materialUnitList, List<MaterialUnitType> materialUnitTypeList, Map<String, String> codeMa, Map<String, String> unitConvertMap) {
        String tenantCode = TenantUtils.getTenantCode();
        masterDataMdgUnitTypeVos.forEach(mdgVo -> {
            if (StringUtils.isEmpty((CharSequence)mdgVo.getMatnr())) {
                return;
            }
            if (StringUtils.isEmpty((CharSequence)mdgVo.getMeinh())) {
                return;
            }
            MaterialUnit materialUnit = new MaterialUnit();
            BigDecimal businessScale = new BigDecimal(mdgVo.getUmren().trim());
            materialUnit.setConvertScale(businessScale);
            BigDecimal baseScale = new BigDecimal(mdgVo.getUmrez().trim());
            materialUnit.setMeasureConvertScale(baseScale);
            if ("ST".equalsIgnoreCase(mdgVo.getMeinh())) {
                mdgVo.setMeinh("PC");
            }
            materialUnit.setUnitCode(mdgVo.getMeinh());
            materialUnit.setUnitName(mdgVo.getMeinhdesc());
            materialUnit.setUnitTypeCode(mdgVo.getMatnr());
            materialUnit.setStandardUnitCode(unitConvertMap.getOrDefault(mdgVo.getMeinhdesc1(), ""));
            materialUnit.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            materialUnit.setTenantCode(tenantCode);
            materialUnit.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            BooleanEnum booleanEnum = Objects.equals(materialUnit.getUnitCode(), materialUnit.getStandardUnitCode()) ? BooleanEnum.TRUE : BooleanEnum.FALSE;
            materialUnit.setStandardUnitFlag(booleanEnum.getCapital());
            materialUnitList.add(materialUnit);
            if (codeMa.containsKey(mdgVo.getMatnr())) {
                return;
            }
            codeMa.put(mdgVo.getMatnr(), "");
            MaterialUnitType materialUnitType = new MaterialUnitType();
            materialUnitType.setUnitTypeCode(mdgVo.getMatnr());
            materialUnitType.setMeasureTypeName(mdgVo.getMeinhdesc1());
            materialUnitType.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            materialUnitType.setTenantCode(tenantCode);
            materialUnitType.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            materialUnitTypeList.add(materialUnitType);
        });
    }

    private boolean lock(String yearMonthDay) {
        if (StringUtils.isEmpty((CharSequence)yearMonthDay)) {
            throw new RuntimeException("\u62c9\u53d6\u7269\u6599\u5355\u4f4d\u52a0\u9501\u5931\u8d25\uff0c\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        return this.redisMutexService.tryLock("materialUnit_lock:lock:" + yearMonthDay, TimeUnit.HOURS, 12);
    }

    private void createValidate(MaterialUnit materialUnit) {
        Validate.notBlank((CharSequence)materialUnit.getUnitName(), (String)"\u7269\u6599\u5355\u4f4d\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)materialUnit.getUnitTypeCode(), (String)"\u7269\u6599\u5355\u4f4d\u7c7b\u522b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)materialUnit.getConvertScale(), (String)"\u7269\u6599\u5355\u4f4d\u8f6c\u6362\u7cfb\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)materialUnit.getStandardUnitFlag(), (String)"\u7269\u6599\u5355\u4f4d\u6807\u51c6\u5355\u4f4d\u6807\u8bb0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((materialUnit.getConvertScale().compareTo(new BigDecimal(BigInteger.ZERO)) > 0 ? 1 : 0) != 0, (String)"\u7269\u6599\u5355\u4f4d\u8f6c\u6362\u7cfb\u6570\u4e0d\u80fd\u5c0f\u4e8e0", (Object[])new Object[0]);
        Validate.notNull((Object)materialUnit.getMeasureConvertScale(), (String)"EA\u5355\u4f4d\u8f6c\u6362\u7cfb\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((materialUnit.getMeasureConvertScale().compareTo(new BigDecimal(BigInteger.ZERO)) > 0 ? 1 : 0) != 0, (String)"EA\u5355\u4f4d\u8f6c\u6362\u7cfb\u6570\u4e0d\u80fd\u5c0f\u4e8e0", (Object[])new Object[0]);
        MaterialUnitType materialUnitType = this.materialUnitTypeRepository.findByUnitTypeCode(materialUnit.getUnitTypeCode());
        Validate.notNull((Object)((Object)materialUnitType), (String)"\u7269\u6599\u5355\u4f4d\u7c7b\u522b\u4e0d\u5b58\u5728\uff01", (Object[])new Object[0]);
    }
}

