package com.biz.crm.mdm.business.material.unit.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.material.unit.dto.MaterialUnitTypeDto;
import com.biz.crm.mdm.business.material.unit.entity.MaterialUnitType;
import com.biz.crm.mdm.business.material.unit.service.MaterialUnitTypeService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author jerry7
 * 物料单位类型 controller
 */
@Api(tags = "物料单位类型")
@RestController
@RequestMapping("v1/materialUnit/materialUnitType")
public class MaterialUnitTypeController {

  @Autowired(required = false)
  private MaterialUnitTypeService materialUnitTypeService;

  /**
   * 分页查询列表
   */
  @ApiOperation(value = "分页查询列表")
  @GetMapping("/findByConditions")
  public Result<Page<MaterialUnitType>> findByConditions(@PageableDefault(50) Pageable pageable,
                                                         MaterialUnitTypeDto dto) {
    return Result.ok(materialUnitTypeService.findByConditions(pageable, dto));
  }

  /**
   * 批量删除
   */
  @ApiOperation(value = "批量删除")
  @DeleteMapping("/deleteBatch")
  public Result<?> delete(@RequestParam List<String> ids) {
    materialUnitTypeService.deleteBatch(ids);
    return Result.ok("删除成功");
  }

  /**
   * 批量启用
   */
  @ApiOperation(value = "批量启用")
  @PatchMapping("/enableBatch")
  public Result<?> enable(@RequestBody List<String> ids) {
    materialUnitTypeService.enableBatch(ids);
    return Result.ok("启用成功");
  }

  /**
   * 批量禁用
   */
  @ApiOperation(value = "批量禁用")
  @PatchMapping("/disableBatch")
  public Result<?> disable(@RequestBody List<String> ids) {
    materialUnitTypeService.disableBatch(ids);
    return Result.ok("禁用成功");
  }


  /**
   * 根据主键id查询物料单位分组详情(包含内部物料单位列表信息)
   * @param id 主键id
   * @return 物料单位分组详情
   */
  @ApiOperation(value = "根据主键id查询")
  @GetMapping("/findById")
  public Result<MaterialUnitType> findById(@RequestParam String id) {
    return Result.ok(this.materialUnitTypeService.findById(id));
  }

  /**
   * 根据物料单位分组编码查询物料单位分组详情(包含内部物料单位列表信息)
   * @param unitTypeCode 物料单位分组编码
   * @return 物料单位分组详情
   */
  @ApiOperation(value = "根据单位分类编码查询")
  @GetMapping("/findByUnitTypeCode")
  public Result<MaterialUnitType> findByUnitTypeCode(@RequestParam String unitTypeCode) {
    return Result.ok(this.materialUnitTypeService.findByUnitTypeCode(unitTypeCode));
  }

  /**
   * 新增
   */
  @ApiOperation(value = "新增")
  @PostMapping("")
  public Result<MaterialUnitType> create(@RequestBody MaterialUnitType materialUnitType) {
    return Result.ok(this.materialUnitTypeService.create(materialUnitType));
  }

  /**
   * 更新
   */
  @ApiOperation(value = "更新")
  @PatchMapping("")
  public Result<MaterialUnitType> update(@RequestBody MaterialUnitType materialUnitType) {
    return Result.ok(this.materialUnitTypeService.update(materialUnitType));
  }

}
