package com.biz.crm.mdm.business.material.unit.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.material.unit.dto.MaterialUnitTypeDto;
import com.biz.crm.mdm.business.material.unit.entity.MaterialUnitType;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * @author jerry7
 * 物料单位类型 service
 */
public interface MaterialUnitTypeService {
    /**
     * 条件分页查询
     * @param pageable 分页参数
     * @param dto 分页查询条件
     * @return 分页数据
     */
    Page<MaterialUnitType> findByConditions(Pageable pageable, MaterialUnitTypeDto dto);

    /**
     * 批量启用
     * @param ids 主键列表
     */
    void enableBatch(List<String> ids);

    /**
     * 批量禁用
     * @param ids 主键列表
     */
    void disableBatch(List<String> ids);

    /**
     * 批量删除
     * @param ids 主键列表
     */
    void deleteBatch(List<String> ids);

    /**
     * 详情
     * @param id 主键id
     * @return 配置实体
     */
    MaterialUnitType findById(String id);

    /**
     * 根据物料类别编码详情
     * @param unitTypeCode 物料类别编码
     * @return 配置实体
     */
    MaterialUnitType findByUnitTypeCode(String unitTypeCode);

    /**
     * 新建配置
     * @param materialUnit 配置实体
     * @return 新建后的实体类
     */
    MaterialUnitType create(MaterialUnitType materialUnit);

    /**
     * 更新配置
     * @param materialUnit 配置实体
     * @return 更新后的实体类
     */
    MaterialUnitType update(MaterialUnitType materialUnit);
}
