/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.material.unit.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.material.unit.dto.MaterialUnitDto;
import com.biz.crm.mdm.business.material.unit.entity.MaterialUnit;
import com.biz.crm.mdm.business.material.unit.mapper.MaterialUnitMapper;
import java.util.List;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class MaterialUnitRepository
extends ServiceImpl<MaterialUnitMapper, MaterialUnit> {
    public Page<MaterialUnit> findByConditions(Page<MaterialUnit> pageable, MaterialUnitDto dto) {
        return ((MaterialUnitMapper)this.baseMapper).findByConditions(pageable, dto);
    }

    public MaterialUnit findByUnitCode(String unitCode) {
        return (MaterialUnit)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MaterialUnit::getUnitCode, (Object)unitCode)).one());
    }

    public List<MaterialUnit> findByUnitTypeCode(String unitTypeCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MaterialUnit::getUnitTypeCode, (Object)unitTypeCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public void updateEnableStatusByIdIn(EnableStatusEnum enable, List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).set(UuidFlagOpEntity::getEnableStatus, (Object)enable.getCode())).update();
    }

    public void updateDelStatusByIdIn(DelFlagStatusEnum delFlagStatusEnum, List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).set(UuidFlagOpEntity::getDelFlag, (Object)delFlagStatusEnum.getCode())).update();
    }

    public void updateDelStatusByUnitType(DelFlagStatusEnum delFlagStatusEnum, String unitTypeCode, List<String> unitCodes) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MaterialUnit::getUnitTypeCode, (Object)unitTypeCode)).notIn(MaterialUnit::getUnitCode, unitCodes)).set(UuidFlagOpEntity::getDelFlag, (Object)delFlagStatusEnum.getCode())).update();
    }
}

