/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.material.unit.service.internal;

import com.biz.crm.mdm.business.material.unit.entity.MaterialUnit;
import com.biz.crm.mdm.business.material.unit.repository.MaterialUnitRepository;
import com.biz.crm.mdm.business.material.unit.service.MaterialUnitVoService;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MaterialUnitVoServiceImpl
implements MaterialUnitVoService {
    @Autowired(required=false)
    private MaterialUnitRepository materialUnitRepository;

    public BigDecimal findScaleByStandUnit(String unitCode) {
        Validate.notBlank((CharSequence)unitCode, (String)"\u9700\u8981\u8f6c\u6362\u7684\u7269\u6599\u5355\u4f4d\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        MaterialUnit materialUnit = this.materialUnitRepository.findByUnitCode(unitCode);
        Validate.notNull((Object)((Object)materialUnit), (String)("\u7269\u6599\u5355\u4f4d\u7f16\u7801" + unitCode + "\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u7269\u6599\u5355\u4f4d\uff01"), (Object[])new Object[0]);
        return materialUnit.getConvertScale();
    }

    public BigDecimal findScaleByGoalUnit(String fromUnitCode, String goalUnitCode, int decimalScale, RoundingMode roundingMode) {
        Validate.isTrue((boolean)ObjectUtils.allNotNull((Object[])new Object[]{fromUnitCode, goalUnitCode}), (String)"\u9700\u8981\u8f6c\u6362\u7684\u7269\u6599\u5355\u4f4d\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        if (ObjectUtils.isEmpty((Object)decimalScale)) {
            decimalScale = 2;
        }
        if (ObjectUtils.isEmpty((Object)((Object)roundingMode))) {
            roundingMode = RoundingMode.HALF_UP;
        }
        MaterialUnit fromMaterialUnit = this.materialUnitRepository.findByUnitCode(fromUnitCode);
        MaterialUnit goalMaterialUnit = this.materialUnitRepository.findByUnitCode(goalUnitCode);
        Validate.isTrue((boolean)ObjectUtils.allNotNull((Object[])new Object[]{fromMaterialUnit, goalMaterialUnit}), (String)"\u9700\u8981\u8f6c\u6362\u7684\u7269\u6599\u5355\u4f4d\u7f16\u7801\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u7269\u6599\u5355\u4f4d\uff01", (Object[])new Object[0]);
        Validate.isTrue((boolean)fromMaterialUnit.getUnitTypeCode().equals(goalMaterialUnit.getUnitTypeCode()), (String)"\u9700\u8981\u8f6c\u6362\u7684\u7269\u6599\u5355\u4f4d\u5fc5\u987b\u662f\u540c\u4e00\u4e2a\u7269\u6599\u5355\u4f4d\u7c7b\u578b\uff01", (Object[])new Object[0]);
        return fromMaterialUnit.getConvertScale().divide(goalMaterialUnit.getConvertScale(), decimalScale, roundingMode);
    }
}

