package com.biz.crm.mdm.business.material.unit.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.*;
import java.util.List;

/**
 * @author jerry7
 * @date 2021/10/26 16:24
 * 物料单位类型实体类
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MaterialUnitType", description = "物料单位类型实体类")
@Entity
@org.hibernate.annotations.Table(appliesTo = "`material_unit_type`", comment = "物料单位类型实体类")
@TableName("material_unit_type")
@Table(name = "`material_unit_type`", indexes = @Index(name = "MaterialUnitType", columnList = "unit_type_code", unique = true))
public class MaterialUnitType extends TenantFlagOpEntity {
  private static final long serialVersionUID = -6697492718261425681L;

  /**
   * 物料单位编码
   */
  @ApiModelProperty("物料单位类型编码")
  @Column(name = "unit_type_code", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 物料单位类型编码 '")
  private String unitTypeCode;

  /**
   * 物料单位名称
   */
  @ApiModelProperty("物料单位类型名称")
  @Column(name = "unit_type_name", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 物料单位类型名称 '")
  private String unitTypeName;

  /**
   * EA单位名称
   */
  @ApiModelProperty("EA单位名称")
  @Column(name = "measure_type_name", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' EA单位名称 '")
  private String measureTypeName;

  /**
   * 关联的物料单位列表
   */
  @ApiModelProperty("物料单位列表")
  @TableField(exist = false)
  @Transient
  private List<MaterialUnit> materialUnits;
}
