/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.material.unit.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.material.unit.dto.MaterialUnitTypeDto;
import com.biz.crm.mdm.business.material.unit.entity.MaterialUnitType;
import com.biz.crm.mdm.business.material.unit.mapper.MaterialUnitTypeMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.List;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class MaterialUnitTypeRepository
extends ServiceImpl<MaterialUnitTypeMapper, MaterialUnitType> {
    public Page<MaterialUnitType> findByConditions(Page<MaterialUnitType> pageable, MaterialUnitTypeDto dto) {
        dto.setTenantCode(TenantUtils.getTenantCode());
        return ((MaterialUnitTypeMapper)this.baseMapper).findByConditions(pageable, dto);
    }

    public List<MaterialUnitType> findDetailsByConditions(MaterialUnitTypeDto dto) {
        dto.setTenantCode(TenantUtils.getTenantCode());
        return ((MaterialUnitTypeMapper)this.baseMapper).findDetailsByConditions(dto);
    }

    public MaterialUnitType findDetailById(String id) {
        return ((MaterialUnitTypeMapper)this.baseMapper).findDetailById(id, TenantUtils.getTenantCode());
    }

    public MaterialUnitType findDetailByUnitTypeCode(String unitTypeCode) {
        return ((MaterialUnitTypeMapper)this.baseMapper).findDetailByUnitTypeCode(unitTypeCode, TenantUtils.getTenantCode());
    }

    public MaterialUnitType findByUnitTypeCode(String unitTypeCode) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"unit_type_code", (Object)unitTypeCode);
        return (MaterialUnitType)((Object)((MaterialUnitTypeMapper)this.baseMapper).selectOne((Wrapper)queryWrapper));
    }

    public void updateEnableStatusByIdIn(EnableStatusEnum enable, List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.set((Object)"enable_status", (Object)enable.getCode());
        updateWrapper.in((Object)"id", ids);
        this.update((Wrapper)updateWrapper);
    }

    public void updateDelStatusByIdIn(DelFlagStatusEnum delFlagStatusEnum, List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.set((Object)"del_flag", (Object)delFlagStatusEnum.getCode());
        updateWrapper.in((Object)"id", ids);
        this.update((Wrapper)updateWrapper);
    }
}

