package com.biz.crm.mdm.business.material.unit.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.material.unit.dto.MaterialUnitDto;
import com.biz.crm.mdm.business.material.unit.entity.MaterialUnit;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * @author jerry7
 * 物料单位service
 */
public interface MaterialUnitService {
    /**
     * 条件分页查询
     * @param pageable 分页参数
     * @param dto 分页查询条件
     * @return 分页数据
     */
    Page<MaterialUnit> findByConditions(Pageable pageable, MaterialUnitDto dto);

    /**
     * 批量启用
     * @param ids 主键列表
     */
    void enableBatch(List<String> ids);

    /**
     * 批量禁用
     * @param ids 主键列表
     */
    void disableBatch(List<String> ids);

    /**
     * 批量删除
     * @param ids 主键列表
     */
    void deleteBatch(List<String> ids);

    /**
     * 根据物料类别批量删除传入物料单位以外的数据
     * @param unitTypeCode 物料类别编码
     */
    void deleteByUnitTypeCode(String unitTypeCode,List<String> unitCodes);

    /**
     * 详情
     * @param id 主键id
     * @return 配置实体
     */
    MaterialUnit findById(String id);

    /**
     * 根据单位类别编码查询单位列表
     * @param unitTypeCode 单位类别编码
     * @return 单位列表
     */
    List<MaterialUnit> findByUnitTypeCode(String unitTypeCode);

    /**
     * 新建配置
     * @param materialUnit 配置实体
     * @return 新建后的实体类
     */
    MaterialUnit create(MaterialUnit materialUnit);

    /**
     * 更新配置
     * @param materialUnit 配置实体
     * @return 更新后的实体类
     */
    MaterialUnit update(MaterialUnit materialUnit);
}
