package com.biz.crm.mdm.business.material.unit.service.internal;

import com.biz.crm.mdm.business.material.unit.dto.MaterialUnitTypeDto;
import com.biz.crm.mdm.business.material.unit.entity.MaterialUnit;
import com.biz.crm.mdm.business.material.unit.repository.MaterialUnitRepository;
import com.biz.crm.mdm.business.material.unit.service.MaterialUnitVoService;
import com.biz.crm.mdm.business.material.unit.vo.MaterialUnitTypeVo;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;

/**
 * @author jerry7
 * 物料单位vo service实现
 */
@Service
public class MaterialUnitVoServiceImpl implements MaterialUnitVoService {

  @Autowired(required = false)
  private MaterialUnitRepository materialUnitRepository;

  @Override
  public BigDecimal findScaleByStandUnit(String unitCode) {
    Validate.notBlank(unitCode, "需要转换的物料单位编码不能为空！");
    MaterialUnit materialUnit = materialUnitRepository.findByUnitCode(unitCode);
    Validate.notNull(materialUnit, "物料单位编码" + unitCode + "找不到对应的物料单位！");
    return materialUnit.getConvertScale();
  }

  @Override
  public BigDecimal findScaleByGoalUnit(String fromUnitCode, String goalUnitCode, int decimalScale, RoundingMode roundingMode) {
    Validate.isTrue(ObjectUtils.allNotNull(fromUnitCode, goalUnitCode), "需要转换的物料单位编码不能为空！");
    if (ObjectUtils.isEmpty(decimalScale)) {
      decimalScale = 2;
    }
    if (ObjectUtils.isEmpty(roundingMode)) {
      roundingMode = RoundingMode.HALF_UP;
    }
    MaterialUnit fromMaterialUnit = materialUnitRepository.findByUnitCode(fromUnitCode);
    MaterialUnit goalMaterialUnit = materialUnitRepository.findByUnitCode(goalUnitCode);
    Validate.isTrue(ObjectUtils.allNotNull(fromMaterialUnit, goalMaterialUnit), "需要转换的物料单位编码找不到对应的物料单位！");
    Validate.isTrue(fromMaterialUnit.getUnitTypeCode().equals(goalMaterialUnit.getUnitTypeCode()), "需要转换的物料单位必须是同一个物料单位类型！");
    return fromMaterialUnit.getConvertScale().divide(goalMaterialUnit.getConvertScale(), decimalScale, roundingMode);
  }
}
