/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.material.unit.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.material.unit.dto.MaterialUnitDto;
import com.biz.crm.mdm.business.material.unit.entity.MaterialUnit;
import com.biz.crm.mdm.business.material.unit.entity.MaterialUnitType;
import com.biz.crm.mdm.business.material.unit.repository.MaterialUnitRepository;
import com.biz.crm.mdm.business.material.unit.repository.MaterialUnitTypeRepository;
import com.biz.crm.mdm.business.material.unit.service.MaterialUnitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class MaterialUnitServiceImpl
implements MaterialUnitService {
    @Autowired(required=false)
    private MaterialUnitRepository materialUnitRepository;
    @Autowired(required=false)
    private MaterialUnitTypeRepository materialUnitTypeRepository;
    @Autowired(required=false)
    private LoginUserService loginUserService;

    @Override
    public Page<MaterialUnit> findByConditions(Pageable pageable, MaterialUnitDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        dto = Optional.ofNullable(dto).orElse(new MaterialUnitDto());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.materialUnitRepository.findByConditions((Page<MaterialUnit>)page, dto);
    }

    @Override
    @Transactional
    public void enableBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u5f85\u4fee\u6b63\u7684\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.materialUnitRepository.updateEnableStatusByIdIn(EnableStatusEnum.ENABLE, ids);
    }

    @Override
    @Transactional
    public void disableBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u5f85\u4fee\u6b63\u7684\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.materialUnitRepository.updateEnableStatusByIdIn(EnableStatusEnum.DISABLE, ids);
    }

    @Override
    @Transactional
    public void deleteBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u5f85\u4fee\u6b63\u7684\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.materialUnitRepository.updateDelStatusByIdIn(DelFlagStatusEnum.DELETE, ids);
    }

    @Override
    public void deleteByUnitTypeCode(String unitTypeCode, List<String> unitCodes) {
        Validate.notNull((Object)unitTypeCode, (String)"\u5f85\u4fee\u6b63\u7684\u7269\u6599\u5355\u4f4d\u7c7b\u522b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.materialUnitRepository.updateDelStatusByUnitType(DelFlagStatusEnum.DELETE, unitTypeCode, unitCodes);
    }

    @Override
    public MaterialUnit findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.materialUnitRepository.findByIdAndTenantCode(id, TenantUtils.getTenantCode());
    }

    @Override
    public List<MaterialUnit> findByUnitTypeCode(String unitTypeCode) {
        return this.materialUnitRepository.findByUnitTypeCode(unitTypeCode);
    }

    @Override
    @Transactional
    public MaterialUnit create(MaterialUnit materialUnit) {
        Validate.notNull((Object)((Object)materialUnit), (String)"\u521b\u5efa\u767b\u5f55\u914d\u7f6e\u5b9e\u4f53\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.createValidate(materialUnit);
        materialUnit.setCreateTime(new Date());
        if (StringUtils.isBlank((CharSequence)materialUnit.getEnableStatus())) {
            materialUnit.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        }
        materialUnit.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        materialUnit.setTenantCode(TenantUtils.getTenantCode());
        materialUnit.setCreateAccount(this.loginUserService.getLoginAccountName());
        this.materialUnitRepository.saveOrUpdate((Object)materialUnit);
        return materialUnit;
    }

    @Override
    @Transactional
    public MaterialUnit update(MaterialUnit materialUnit) {
        Validate.notNull((Object)((Object)materialUnit), (String)"\u66f4\u65b0\u767b\u5f55\u914d\u7f6e\u5b9e\u4f53\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)materialUnit.getId(), (String)"\u767b\u5f55\u767b\u5f55\u914d\u7f6eID\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.createValidate(materialUnit);
        materialUnit.setModifyTime(new Date());
        materialUnit.setModifyAccount(this.loginUserService.getLoginAccountName());
        materialUnit.setTenantCode(TenantUtils.getTenantCode());
        this.materialUnitRepository.saveOrUpdate((Object)materialUnit);
        return materialUnit;
    }

    private void createValidate(MaterialUnit materialUnit) {
        Validate.notBlank((CharSequence)materialUnit.getUnitName(), (String)"\u7269\u6599\u5355\u4f4d\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)materialUnit.getUnitTypeCode(), (String)"\u7269\u6599\u5355\u4f4d\u7c7b\u522b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)materialUnit.getConvertScale(), (String)"\u7269\u6599\u5355\u4f4d\u8f6c\u6362\u7cfb\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)materialUnit.getStandardUnitFlag(), (String)"\u7269\u6599\u5355\u4f4d\u6807\u51c6\u5355\u4f4d\u6807\u8bb0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((materialUnit.getConvertScale().compareTo(new BigDecimal(BigInteger.ZERO)) > 0 ? 1 : 0) != 0, (String)"\u7269\u6599\u5355\u4f4d\u8f6c\u6362\u7cfb\u6570\u4e0d\u80fd\u5c0f\u4e8e0", (Object[])new Object[0]);
        Validate.notNull((Object)materialUnit.getMeasureConvertScale(), (String)"EA\u5355\u4f4d\u8f6c\u6362\u7cfb\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((materialUnit.getMeasureConvertScale().compareTo(new BigDecimal(BigInteger.ZERO)) > 0 ? 1 : 0) != 0, (String)"EA\u5355\u4f4d\u8f6c\u6362\u7cfb\u6570\u4e0d\u80fd\u5c0f\u4e8e0", (Object[])new Object[0]);
        MaterialUnitType materialUnitType = this.materialUnitTypeRepository.findByUnitTypeCode(materialUnit.getUnitTypeCode());
        Validate.notNull((Object)((Object)materialUnitType), (String)"\u7269\u6599\u5355\u4f4d\u7c7b\u522b\u4e0d\u5b58\u5728\uff01", (Object[])new Object[0]);
    }
}

