/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.material.unit.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.material.unit.dto.MaterialUnitTypeDto;
import com.biz.crm.mdm.business.material.unit.entity.MaterialUnit;
import com.biz.crm.mdm.business.material.unit.entity.MaterialUnitType;
import com.biz.crm.mdm.business.material.unit.event.MaterialUnitChangeListener;
import com.biz.crm.mdm.business.material.unit.repository.MaterialUnitTypeRepository;
import com.biz.crm.mdm.business.material.unit.service.MaterialUnitService;
import com.biz.crm.mdm.business.material.unit.service.MaterialUnitTypeService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class MaterialUnitTypeServiceImpl
implements MaterialUnitTypeService {
    @Autowired(required=false)
    private MaterialUnitTypeRepository materialUnitTypeRepository;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private MaterialUnitService materialUnitService;
    @Autowired(required=false)
    @Lazy
    private List<MaterialUnitChangeListener> materialUnitChangeListeners;

    @Override
    public Page<MaterialUnitType> findByConditions(Pageable pageable, MaterialUnitTypeDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        dto = Optional.ofNullable(dto).orElse(new MaterialUnitTypeDto());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.materialUnitTypeRepository.findByConditions((Page<MaterialUnitType>)page, dto);
    }

    @Override
    @Transactional
    public void enableBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u5f85\u4fee\u6b63\u7684\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.materialUnitTypeRepository.updateEnableStatusByIdIn(EnableStatusEnum.ENABLE, ids);
    }

    @Override
    @Transactional
    public void disableBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u5f85\u4fee\u6b63\u7684\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.materialUnitTypeRepository.updateEnableStatusByIdIn(EnableStatusEnum.DISABLE, ids);
    }

    @Override
    @Transactional
    public void deleteBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u5f85\u4fee\u6b63\u7684\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (!CollectionUtils.isEmpty(this.materialUnitChangeListeners) && !CollectionUtils.isEmpty(ids)) {
            ids.forEach(oldUnit -> {
                MaterialUnitType type = this.findById((String)oldUnit);
                if (ObjectUtils.isNotEmpty((Object)((Object)type))) {
                    for (MaterialUnitChangeListener listener : this.materialUnitChangeListeners) {
                        listener.onDeleteUnitType(type.getUnitTypeCode());
                    }
                }
            });
        }
        this.materialUnitTypeRepository.updateDelStatusByIdIn(DelFlagStatusEnum.DELETE, ids);
    }

    @Override
    public MaterialUnitType findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        MaterialUnitType detailById = this.materialUnitTypeRepository.findDetailById(id);
        if (Objects.isNull((Object)detailById)) {
            return null;
        }
        List<MaterialUnit> byUnitTypeCode = this.materialUnitService.findByUnitTypeCode(detailById.getUnitTypeCode());
        detailById.setMaterialUnits(byUnitTypeCode);
        return detailById;
    }

    @Override
    public MaterialUnitType findByUnitTypeCode(String materialTypeCode) {
        if (StringUtils.isBlank((CharSequence)materialTypeCode)) {
            return null;
        }
        return this.materialUnitTypeRepository.findDetailByUnitTypeCode(materialTypeCode);
    }

    @Override
    @Transactional
    public MaterialUnitType create(MaterialUnitType materialUnitType) {
        this.createValidate(materialUnitType);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)materialUnitType.getId()), (String)"\u521b\u5efa\u767b\u5f55\u914d\u7f6eID\u4e0d\u80fd\u6709\u503c\uff01", (Object[])new Object[0]);
        materialUnitType.setCreateTime(new Date());
        materialUnitType.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        materialUnitType.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        materialUnitType.setTenantCode(TenantUtils.getTenantCode());
        materialUnitType.setCreateAccount(this.loginUserService.getLoginAccountName());
        List codes = this.generateCodeService.generateCode("MU", 1);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)codes) ? 1 : 0) != 0, (String)"\u751f\u6210\u7269\u6599\u5355\u4f4d\u7c7b\u522b\u7f16\u7801\u5931\u8d25\uff01", (Object[])new Object[0]);
        materialUnitType.setUnitTypeCode((String)codes.stream().findFirst().get());
        this.materialUnitTypeRepository.save((Object)materialUnitType);
        List<MaterialUnit> materialUnits = materialUnitType.getMaterialUnits();
        materialUnits.forEach(materialUnit -> {
            materialUnit.setUnitTypeCode(materialUnitType.getUnitTypeCode());
            materialUnit.setTenantCode(materialUnitType.getTenantCode());
            this.materialUnitService.create((MaterialUnit)((Object)materialUnit));
        });
        return materialUnitType;
    }

    @Override
    @Transactional
    public MaterialUnitType update(MaterialUnitType materialUnitType) {
        this.createValidate(materialUnitType);
        Validate.notBlank((CharSequence)materialUnitType.getId(), (String)"\u767b\u5f55\u767b\u5f55\u914d\u7f6eID\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        materialUnitType.setModifyTime(new Date());
        materialUnitType.setModifyAccount(this.loginUserService.getLoginAccountName());
        materialUnitType.setTenantCode(TenantUtils.getTenantCode());
        this.materialUnitTypeRepository.saveOrUpdate((Object)materialUnitType);
        List<MaterialUnit> materialUnits = materialUnitType.getMaterialUnits();
        List<String> unitCodes = materialUnits.stream().map(MaterialUnit::getUnitCode).collect(Collectors.toList());
        List<MaterialUnit> oldUnits = this.materialUnitService.findByUnitTypeCode(materialUnitType.getUnitTypeCode());
        if (!CollectionUtils.isEmpty(this.materialUnitChangeListeners) && !CollectionUtils.isEmpty(oldUnits)) {
            oldUnits.forEach(oldUnit -> {
                if (!unitCodes.contains(oldUnit.getUnitCode())) {
                    for (MaterialUnitChangeListener listener : this.materialUnitChangeListeners) {
                        listener.onDelete(oldUnit.getUnitCode());
                    }
                }
            });
        }
        this.materialUnitService.deleteByUnitTypeCode(materialUnitType.getUnitTypeCode(), unitCodes);
        materialUnits.forEach(materialUnit -> {
            materialUnit.setUnitTypeCode(materialUnitType.getUnitTypeCode());
            materialUnit.setTenantCode(materialUnitType.getTenantCode());
            this.materialUnitService.create((MaterialUnit)((Object)materialUnit));
        });
        return materialUnitType;
    }

    private void createValidate(MaterialUnitType materialUnitType) {
        Validate.notNull((Object)((Object)materialUnitType), (String)"\u66f4\u65b0\u767b\u5f55\u914d\u7f6e\u5b9e\u4f53\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)materialUnitType.getMeasureTypeName(), (String)"EA\u5355\u4f4d\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull(materialUnitType.getMaterialUnits(), (String)"\u7269\u6599\u5355\u4f4d\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<MaterialUnit> materialUnits = materialUnitType.getMaterialUnits();
        Validate.isTrue((!CollectionUtils.isEmpty(materialUnits) ? 1 : 0) != 0, (String)"\u8bf7\u81f3\u5c11\u6dfb\u52a0\u4e00\u4e2a\u5355\u4f4d\u7684\u4fe1\u606f", (Object[])new Object[0]);
        materialUnits.sort(Comparator.comparing(MaterialUnit::getConvertScale).reversed());
        MaterialUnit firstUnit = materialUnits.get(0);
        StringBuilder unitTypeName = new StringBuilder(1 + firstUnit.getUnitName());
        for (int i = 1; i < materialUnits.size(); ++i) {
            BigDecimal v = firstUnit.getConvertScale().divide(materialUnits.get(i).getConvertScale(), 2, RoundingMode.HALF_UP);
            unitTypeName.append("=").append(this.hasDecimal(v) != false ? v : Integer.valueOf(v.intValue())).append(materialUnits.get(i).getUnitName());
        }
        materialUnitType.setUnitTypeName(unitTypeName.toString());
        List codes = this.generateCodeService.generateCode("MU", materialUnits.size());
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)codes) ? 1 : 0) != 0, (String)"\u751f\u6210\u7269\u6599\u5355\u4f4d\u7c7b\u522b\u7f16\u7801\u5931\u8d25\uff01", (Object[])new Object[0]);
        HashMap unitMap = Maps.newHashMap();
        for (int i = 0; i < materialUnits.size(); ++i) {
            MaterialUnit unit = materialUnits.get(i);
            ArrayList unitList = Lists.newArrayList();
            if (unitMap.containsKey(unit.getStandardUnitFlag())) {
                unitList.addAll((Collection)unitMap.get(unit.getStandardUnitFlag()));
            }
            unitList.add(unit);
            unitMap.put(unit.getStandardUnitFlag(), unitList);
            if (!StringUtils.isBlank((CharSequence)unit.getUnitCode())) continue;
            unit.setUnitCode((String)codes.get(i));
        }
        Validate.isTrue((unitMap.containsKey(BooleanEnum.TRUE.getCapital()) && ((List)unitMap.get(BooleanEnum.TRUE.getCapital())).size() == 1 ? 1 : 0) != 0, (String)"\u4e00\u4e2a\u7269\u6599\u5355\u4f4d\u7ec4\u5185\u57fa\u672c\u5355\u4f4d\u6709\u4e14\u53ea\u80fd\u6709\u4e00\u4e2a", (Object[])new Object[0]);
        materialUnits.forEach(materialUnit -> materialUnit.setStandardUnitCode(((MaterialUnit)((Object)((Object)((List)unitMap.get(BooleanEnum.TRUE.getCapital())).get(0)))).getUnitCode()));
    }

    private Boolean hasDecimal(BigDecimal v) {
        String split = ".";
        if (Objects.isNull(v)) {
            return false;
        }
        String str = Optional.of(v).orElse(BigDecimal.ZERO).toString();
        if (str.contains(split)) {
            String s = StringUtils.split((String)str, (String)split)[1];
            return BigDecimal.ZERO.compareTo(new BigDecimal(s)) < 0;
        }
        return false;
    }
}

