package com.biz.crm.mdm.business.material.unit.vo;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * @author jerry7
 * @date 2021/10/26 16:24
 * 物料单位VO
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MaterialUnitVo", description = "物料单位回显类")
public class MaterialUnitVo extends TenantFlagOpVo {
  private static final long serialVersionUID = 8599246341788262253L;

  /**
   * 物料单位编码
   */
  @ApiModelProperty("物料单位编码")
  private String unitCode;

  /**
   * 物料单位名称
   */
  @ApiModelProperty("物料单位名称")
  private String unitName;

  /**
   * 物料单位编码
   */
  @ApiModelProperty("物料单位类型编码")
  private String unitTypeCode;

  /**
   * 物料单位换算系数
   */
  @ApiModelProperty("物料单位换算系数")
  private BigDecimal convertScale;

  /**
   * EA单位换算系数
   */
  @ApiModelProperty("EA单位换算系数")
  private BigDecimal measureConvertScale;

  /**
   * 是否标准单位标准(Y/N)
   */
  @ApiModelProperty("是否标准单位标准(Y/N)")
  private String standardUnitFlag;

  /**
   * 标准物料单位编码
   */
  @ApiModelProperty("标准物料单位编码")
  private String standardUnitCode;
}
