package com.biz.crm.mdm.business.material.unit.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;

/**
 * @author jerry7
 * @date 2021/10/26 16:24
 * 物料单位实体类
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MaterialUnit", description = "物料单位实体类")
public class MaterialUnitDto extends TenantFlagOpDto {

  /**
   * 物料单位编码
   */
  @ApiModelProperty("物料单位编码")
  private String unitCode;

  /**
   * 物料单位名称
   */
  @ApiModelProperty("物料单位名称")
  private String unitName;

  /**
   * 物料单位编码
   */
  @ApiModelProperty("物料单位类型编码")
  private String unitTypeCode;

  /**
   * 物料单位换算系数
   */
  @ApiModelProperty("物料单位换算系数")
  private BigDecimal convertScale;

  /**
   * 是否标准单位标准(Y/N)
   */
  @ApiModelProperty("是否标准单位标准(Y/N)")
  private String standardUnitFlag;

  /**
   * 标准物料单位编码
   */
  @ApiModelProperty("标准物料单位编码")
  private String standardUnitCode;
}
