package com.biz.crm.mdm.business.material.unit.dto;

import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import java.util.List;

/**
 * @author jerry7
 * @date 2021/10/26 16:24
 * 物料单位类型实体类
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MaterialUnitType", description = "物料单位类型实体类")
public class MaterialUnitTypeDto extends TenantFlagOpDto {
  private static final long serialVersionUID = 3123244625894446525L;

  /**
   * 物料单位编码
   */
  @ApiModelProperty("物料单位类型编码")
  private String unitTypeCode;

  /**
   * 物料单位名称
   */
  @ApiModelProperty("物料单位类型名称")
  private String unitTypeName;

  /**
   * 物料单位类型编码集合
   */
  @ApiModelProperty("物料单位类型编码集合")
  private List<String> unitTypeCodes;
}
