package com.biz.crm.mdm.business.material.unit.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.*;
import java.util.List;

/**
 * @author jerry7
 * @date 2021/10/26 16:24
 * 物料单位类型VO
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MaterialUnitTypeVo", description = "物料单位类型回显类")
public class MaterialUnitTypeVo extends TenantFlagOpVo {
  private static final long serialVersionUID = -6697492718261425681L;

  /**
   * 物料单位编码
   */
  @ApiModelProperty("物料单位类型编码")
  private String unitTypeCode;

  /**
   * 物料单位名称
   */
  @ApiModelProperty("物料单位类型名称")
  private String unitTypeName;

  /**
   * EA单位名称
   */
  @ApiModelProperty("EA单位名称")
  private String measureTypeName;

  /**
   * 关联的物料单位列表
   */
  @ApiModelProperty("物料单位列表")
  private List<MaterialUnitVo> materialUnits;
}
