/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.material.unit.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.material.unit.dto.MaterialUnitDto;
import com.biz.crm.mdm.business.material.unit.entity.MaterialUnit;
import com.biz.crm.mdm.business.material.unit.entity.MaterialUnitType;
import com.biz.crm.mdm.business.material.unit.repository.MaterialUnitRepository;
import com.biz.crm.mdm.business.material.unit.repository.MaterialUnitTypeRepository;
import com.biz.crm.mdm.business.material.unit.service.MaterialUnitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class MaterialUnitServiceImpl
implements MaterialUnitService {
    @Autowired
    private MaterialUnitRepository materialUnitRepository;
    @Autowired
    private MaterialUnitTypeRepository materialUnitTypeRepository;
    @Autowired
    private LoginUserService loginUserService;
    @Autowired
    private GenerateCodeService generateCodeService;

    @Override
    public Page<MaterialUnit> findByConditions(Pageable pageable, MaterialUnitDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        dto = Optional.ofNullable(dto).orElse(new MaterialUnitDto());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.materialUnitRepository.findByConditions((Page<MaterialUnit>)page, dto);
    }

    @Override
    @Transactional
    public void enableBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u5f85\u4fee\u6b63\u7684\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.materialUnitRepository.updateEnableStatusByIdIn(EnableStatusEnum.ENABLE, ids);
    }

    @Override
    @Transactional
    public void disableBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u5f85\u4fee\u6b63\u7684\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.materialUnitRepository.updateEnableStatusByIdIn(EnableStatusEnum.DISABLE, ids);
    }

    @Override
    @Transactional
    public void deleteBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u5f85\u4fee\u6b63\u7684\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.materialUnitRepository.updateDelStatusByIdIn(DelFlagStatusEnum.DELETE, ids);
    }

    @Override
    public MaterialUnit findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return (MaterialUnit)((Object)this.materialUnitRepository.getById((Serializable)((Object)id)));
    }

    @Override
    @Transactional
    public MaterialUnit create(MaterialUnit materialUnit) {
        Validate.notNull((Object)((Object)materialUnit), (String)"\u521b\u5efa\u767b\u5f55\u914d\u7f6e\u5b9e\u4f53\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)materialUnit.getId()), (String)"\u521b\u5efa\u767b\u5f55\u914d\u7f6eID\u4e0d\u80fd\u6709\u503c\uff01", (Object[])new Object[0]);
        this.createValidate(materialUnit);
        MaterialUnitDto materialUnitDto = new MaterialUnitDto();
        materialUnitDto.setUnitTypeCode(materialUnit.getUnitTypeCode());
        materialUnitDto.setStandardUnitFlag(BooleanEnum.TRUE.getCapital());
        Page<MaterialUnit> page = this.findByConditions((Pageable)PageRequest.of((int)0, (int)50), materialUnitDto);
        if (CollectionUtils.isEmpty((Collection)page.getRecords())) {
            Validate.isTrue((boolean)BooleanEnum.TRUE.getCapital().equals(materialUnit.getStandardUnitFlag()), (String)"\u6b64\u5355\u4f4d\u7c7b\u522b\u5c1a\u672a\u521b\u5efa\u6807\u51c6\u5355\u4f4d\uff0c\u8bf7\u5148\u521b\u5efa\u6807\u51c6\u5355\u4f4d", (Object[])new Object[0]);
        } else {
            Validate.isTrue((boolean)BooleanEnum.FALSE.getCapital().equals(materialUnit.getStandardUnitFlag()), (String)"\u6b64\u5355\u4f4d\u7c7b\u522b\u5df2\u7ecf\u521b\u5efa\u6807\u51c6\u5355\u4f4d\uff0c\u65e0\u6cd5\u521b\u5efa\u6807\u51c6\u5355\u4f4d", (Object[])new Object[0]);
            materialUnit.setStandardUnitCode(((MaterialUnit)((Object)page.getRecords().stream().findFirst().get())).getUnitCode());
        }
        materialUnit.setCreateTime(new Date());
        materialUnit.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        materialUnit.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        materialUnit.setTenantCode(TenantUtils.getTenantCode());
        materialUnit.setCreateAccount(this.loginUserService.getLoginAccountName());
        List codes = this.generateCodeService.generateCode("materialUnitCode", 1);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)codes) ? 1 : 0) != 0, (String)"\u751f\u6210\u7269\u6599\u5355\u4f4d\u7c7b\u522b\u7f16\u7801\u5931\u8d25\uff01", (Object[])new Object[0]);
        materialUnit.setUnitCode((String)codes.stream().findFirst().get());
        this.materialUnitRepository.save((Object)materialUnit);
        return materialUnit;
    }

    @Override
    @Transactional
    public MaterialUnit update(MaterialUnit materialUnit) {
        Validate.notNull((Object)((Object)materialUnit), (String)"\u66f4\u65b0\u767b\u5f55\u914d\u7f6e\u5b9e\u4f53\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)materialUnit.getId(), (String)"\u767b\u5f55\u767b\u5f55\u914d\u7f6eID\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.createValidate(materialUnit);
        materialUnit.setModifyTime(new Date());
        materialUnit.setModifyAccount(this.loginUserService.getLoginAccountName());
        this.materialUnitRepository.saveOrUpdate((Object)materialUnit);
        return materialUnit;
    }

    private void createValidate(MaterialUnit materialUnit) {
        Validate.notBlank((CharSequence)materialUnit.getUnitName(), (String)"\u7269\u6599\u5355\u4f4d\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)materialUnit.getUnitTypeCode(), (String)"\u7269\u6599\u5355\u4f4d\u7c7b\u522b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)materialUnit.getConvertScale(), (String)"\u7269\u6599\u5355\u4f4d\u8f6c\u6362\u7cfb\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)materialUnit.getStandardUnitFlag(), (String)"\u7269\u6599\u5355\u4f4d\u6807\u51c6\u5355\u4f4d\u6807\u8bb0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((materialUnit.getConvertScale().compareTo(new BigDecimal(BigInteger.ZERO)) > 0 ? 1 : 0) != 0, (String)"\u7269\u6599\u5355\u4f4d\u8f6c\u6362\u7cfb\u6570\u4e0d\u80fd\u5c0f\u4e8e0", (Object[])new Object[0]);
        MaterialUnitType materialUnitType = this.materialUnitTypeRepository.findByUnitTypeCode(materialUnit.getUnitTypeCode());
        Validate.notNull((Object)((Object)materialUnitType), (String)"\u7269\u6599\u5355\u4f4d\u7c7b\u522b\u4e0d\u5b58\u5728\uff01", (Object[])new Object[0]);
    }
}

