/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.material.unit.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.material.unit.dto.MaterialUnitTypeDto;
import com.biz.crm.mdm.business.material.unit.entity.MaterialUnitType;
import com.biz.crm.mdm.business.material.unit.repository.MaterialUnitTypeRepository;
import com.biz.crm.mdm.business.material.unit.service.MaterialUnitTypeService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class MaterialUnitTypeServiceImpl
implements MaterialUnitTypeService {
    @Autowired
    private MaterialUnitTypeRepository materialUnitTypeRepository;
    @Autowired
    private LoginUserService loginUserService;
    @Autowired
    private GenerateCodeService generateCodeService;

    @Override
    public Page<MaterialUnitType> findByConditions(Pageable pageable, MaterialUnitTypeDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        dto = Optional.ofNullable(dto).orElse(new MaterialUnitTypeDto());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.materialUnitTypeRepository.findByConditions((Page<MaterialUnitType>)page, dto);
    }

    @Override
    @Transactional
    public void enableBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u5f85\u4fee\u6b63\u7684\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.materialUnitTypeRepository.updateEnableStatusByIdIn(EnableStatusEnum.ENABLE, ids);
    }

    @Override
    @Transactional
    public void disableBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u5f85\u4fee\u6b63\u7684\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.materialUnitTypeRepository.updateEnableStatusByIdIn(EnableStatusEnum.DISABLE, ids);
    }

    @Override
    @Transactional
    public void deleteBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u5f85\u4fee\u6b63\u7684\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.materialUnitTypeRepository.updateDelStatusByIdIn(DelFlagStatusEnum.DELETE, ids);
    }

    @Override
    public MaterialUnitType findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.materialUnitTypeRepository.findDetailById(id);
    }

    @Override
    @Transactional
    public MaterialUnitType create(MaterialUnitType materialUnitType) {
        this.createValidate(materialUnitType);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)materialUnitType.getId()), (String)"\u521b\u5efa\u767b\u5f55\u914d\u7f6eID\u4e0d\u80fd\u6709\u503c\uff01", (Object[])new Object[0]);
        materialUnitType.setCreateTime(new Date());
        materialUnitType.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        materialUnitType.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        materialUnitType.setTenantCode(TenantUtils.getTenantCode());
        materialUnitType.setCreateAccount(this.loginUserService.getLoginAccountName());
        List codes = this.generateCodeService.generateCode("materialUnitTypeCode", 1);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)codes) ? 1 : 0) != 0, (String)"\u751f\u6210\u7269\u6599\u5355\u4f4d\u7c7b\u522b\u7f16\u7801\u5931\u8d25\uff01", (Object[])new Object[0]);
        materialUnitType.setUnitTypeCode((String)codes.stream().findFirst().get());
        this.materialUnitTypeRepository.save((Object)materialUnitType);
        return materialUnitType;
    }

    @Override
    @Transactional
    public MaterialUnitType update(MaterialUnitType materialUnitType) {
        this.createValidate(materialUnitType);
        Validate.notBlank((CharSequence)materialUnitType.getId(), (String)"\u767b\u5f55\u767b\u5f55\u914d\u7f6eID\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        materialUnitType.setModifyTime(new Date());
        materialUnitType.setModifyAccount(this.loginUserService.getLoginAccountName());
        this.materialUnitTypeRepository.saveOrUpdate((Object)materialUnitType);
        return materialUnitType;
    }

    private void createValidate(MaterialUnitType materialUnitType) {
        Validate.notNull((Object)((Object)materialUnitType), (String)"\u66f4\u65b0\u767b\u5f55\u914d\u7f6e\u5b9e\u4f53\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)materialUnitType.getUnitTypeName(), (String)"\u7269\u6599\u5355\u4f4d\u7c7b\u522b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((materialUnitType.getUnitTypeName().length() <= 64 ? 1 : 0) != 0, (String)"\u7269\u6599\u5355\u4f4d\u7c7b\u522b\u540d\u79f0\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc764\u4f4d", (Object[])new Object[0]);
    }
}

