package com.biz.crm.mdm.business.message.local.register.handler;

import com.biz.crm.common.message.sdk.dto.SysMessageItemDto;
import com.biz.crm.common.message.sdk.enums.MessageHandlerEnum;
import com.biz.crm.common.message.sdk.register.SystemMessageHandlerRegister;
import com.biz.crm.common.message.sdk.service.SystemMessageVoService;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

/**
 * 10天未发货通知关联的业务员
 *
 * @author sunx
 * @date 2022/7/4
 */
@Slf4j
@Component
public class DeliveryDelayUserMessageHandlerRegisterImpl implements SystemMessageHandlerRegister {

  @Autowired(required = false)
  private SystemMessageVoService systemMessageVoService;

  @Override
  public String getCode() {
    return MessageHandlerEnum.DELIVERY_DELAY_USER.getDictCode();
  }

  @Override
  public String getName() {
    return MessageHandlerEnum.DELIVERY_DELAY_USER.getValue();
  }

  @Override
  public String getNoticeDesc() {
    return "员工";
  }

  @Override
  public String getContent() {
    return "您的订单${orderCode}超10天未发货了，请尽快联系相关人员处理。";
  }

  @Override
  public int getOrder() {
    return 2;
  }

  @Override
  @Transactional
  public void sendMessage(String messageCode, List<SysMessageItemDto> list) {
    this.systemMessageVoService.create(messageCode, list, this.getContent());
  }
}
