package com.biz.crm.mdm.business.message.local.register.handler;

import com.alibaba.fastjson.JSON;
import com.biz.crm.common.message.sdk.dto.SysMessageItemDto;
import com.biz.crm.common.message.sdk.enums.MessageHandlerEnum;
import com.biz.crm.common.message.sdk.register.SystemMessageHandlerRegister;
import com.biz.crm.common.message.sdk.service.SystemMessageVoService;
import java.util.List;

import com.biz.crm.common.message.sdk.util.ContentHolderUtil;
import com.biz.crm.common.message.sdk.vo.SystemMessageVo;
import com.biz.crm.mdm.business.message.local.constant.MessageConstant;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.gateway.websocket.client.sdk.service.ChannelMsgService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

/**
 * 10天未发货通知关联的业务员
 *
 * @author sunx
 * @date 2022/7/4
 */
@Slf4j
@Component
public class DeliveryDelayUserMessageHandlerRegisterImpl implements SystemMessageHandlerRegister {

  @Autowired(required = false)
  private SystemMessageVoService systemMessageVoService;
  @Autowired
  private ChannelMsgService channelMsgService;
  @Value("${spring.application.name:}")
  private String applicationName;

  @Override
  public String getCode() {
    return MessageHandlerEnum.DELIVERY_DELAY_USER.getDictCode();
  }

  @Override
  public String getName() {
    return MessageHandlerEnum.DELIVERY_DELAY_USER.getValue();
  }

  @Override
  public String getNoticeDesc() {
    return "员工";
  }

  @Override
  public String getContent() {
    return "您的订单${orderCode}超10天未发货了，请尽快联系相关人员处理。";
  }

  @Override
  public int getOrder() {
    return 2;
  }

  @Override
  @Transactional
  public void sendMessage(String messageCode, List<SysMessageItemDto> list) {
    List<SystemMessageVo> messageVoList = this.systemMessageVoService.create(messageCode, list, this.getContent());
    for (SystemMessageVo item : messageVoList) {
      this.channelMsgService.sendByTenantCodeAndApplicationNameAndModelCodeAndAccount(
          TenantUtils.getTenantCode(), applicationName, MessageConstant.SYSTEM_MESSAGE, item.getBusinessCode()
          , JSON.toJSONString(item).getBytes());
    }
  }
}
