/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.news.notice.local.service.internal;

import com.biz.crm.mdm.business.news.notice.local.entity.NewsNoticeScopeEntity;
import com.biz.crm.mdm.business.news.notice.local.repository.NewsNoticeScopeRepository;
import com.biz.crm.mdm.business.news.notice.local.service.NewsNoticeScopeService;
import com.biz.crm.mdm.business.news.notice.sdk.dto.base.ScopeDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="noticeScopeService")
public class NewsNoticeScopeServiceImpl
implements NewsNoticeScopeService {
    @Autowired(required=false)
    private NewsNoticeScopeRepository newsNoticeScopeRepository;
    @Autowired(required=false)
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;

    @Override
    @Transactional
    public void update(List<ScopeDto> dtoList, String noticeId) {
        Validate.notBlank((CharSequence)noticeId, (String)"\u516c\u544aID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.newsNoticeScopeRepository.deleteByNoticeId(noticeId);
        if (CollectionUtils.isEmpty(dtoList)) {
            return;
        }
        String tenantCode = TenantUtils.getTenantCode();
        List entities = dtoList.stream().filter(dto -> Objects.nonNull(dto) && StringUtils.isNotEmpty((CharSequence)dto.getScopeCode()) && StringUtils.isNotEmpty((CharSequence)dto.getScopeType())).map(dto -> {
            NewsNoticeScopeEntity entity = (NewsNoticeScopeEntity)((Object)((Object)this.nebulaToolkitService.copyObjectByWhiteList(dto, NewsNoticeScopeEntity.class, HashSet.class, ArrayList.class, new String[0])));
            entity.setNoticeId(noticeId);
            entity.setTenantCode(tenantCode);
            return entity;
        }).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(entities)) {
            return;
        }
        this.newsNoticeScopeRepository.saveBatch(entities);
    }
}

