/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.news.notice.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.business.common.sdk.vo.UuidVo;
import com.biz.crm.mdm.business.news.notice.local.entity.NewsNoticeEntity;
import com.biz.crm.mdm.business.news.notice.local.entity.NewsNoticeReadRecordEntity;
import com.biz.crm.mdm.business.news.notice.local.model.NewsNoticeModelVo;
import com.biz.crm.mdm.business.news.notice.local.model.PageResult;
import com.biz.crm.mdm.business.news.notice.local.repository.NewsNoticeFileRepository;
import com.biz.crm.mdm.business.news.notice.local.repository.NewsNoticeModelRepository;
import com.biz.crm.mdm.business.news.notice.local.repository.NewsNoticeReadRecordRepository;
import com.biz.crm.mdm.business.news.notice.local.repository.NewsNoticeRepository;
import com.biz.crm.mdm.business.news.notice.local.repository.NewsNoticeScopeRepository;
import com.biz.crm.mdm.business.news.notice.local.service.base.AbstractRelationDataService;
import com.biz.crm.mdm.business.news.notice.sdk.dto.NewsNoticeCustomerPageDto;
import com.biz.crm.mdm.business.news.notice.sdk.dto.NewsNoticeDto;
import com.biz.crm.mdm.business.news.notice.sdk.dto.NewsNoticePageDto;
import com.biz.crm.mdm.business.news.notice.sdk.dto.base.AbstractCustomerPageDto;
import com.biz.crm.mdm.business.news.notice.sdk.enums.ScopeType;
import com.biz.crm.mdm.business.news.notice.sdk.service.NewsNoticeVoService;
import com.biz.crm.mdm.business.news.notice.sdk.vo.NewsNoticeVo;
import com.biz.crm.mdm.business.org.sdk.service.OrgPositionVoService;
import com.biz.crm.mdm.business.org.sdk.service.OrgVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgPositionVo;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import com.biz.crm.mdm.business.user.sdk.service.UserPositionVoService;
import com.biz.crm.mdm.business.user.sdk.vo.UserPositionVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class NewsNoticeVoServiceImpl
extends AbstractRelationDataService
implements NewsNoticeVoService {
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private NewsNoticeRepository newsNoticeRepository;
    @Autowired(required=false)
    private NewsNoticeModelRepository newsNoticeModelRepository;
    @Autowired(required=false)
    private NewsNoticeReadRecordRepository newsNoticeReadRecordRepository;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private NewsNoticeFileRepository newsNoticeFileRepository;
    @Autowired(required=false)
    private NewsNoticeScopeRepository newsNoticeScopeRepository;
    @Autowired(required=false)
    private UserPositionVoService userPositionVoService;
    @Autowired(required=false)
    private OrgPositionVoService orgPositionVoService;
    @Autowired(required=false)
    private OrgVoService orgVoService;

    public Page<NewsNoticeVo> findByConditions(Pageable pageable, NewsNoticePageDto dto) {
        Set<Object> positionCodeSet;
        Map<Object, Object> orgToPositionMap;
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        dto = (NewsNoticePageDto)ObjectUtils.defaultIfNull((Object)dto, (Object)new NewsNoticePageDto());
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page<NewsNoticeModelVo> modelPage = this.newsNoticeModelRepository.findByConditions(pageable, dto);
        Page pageResult = new Page(modelPage.getCurrent(), modelPage.getSize(), modelPage.getTotal());
        if (CollectionUtils.isEmpty((Collection)modelPage.getRecords())) {
            return pageResult;
        }
        List list = (List)this.nebulaToolkitService.copyCollectionByBlankList((Iterable)modelPage.getRecords(), NewsNoticeModelVo.class, NewsNoticeVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        pageResult.setRecords(list);
        Set orgCodeSet = list.stream().map(NewsNoticeVo::getPublishOrgCode).collect(Collectors.toSet());
        List allChildren = this.orgVoService.findAllChildrenByOrgCodes((List)Lists.newArrayList(orgCodeSet));
        Set childrenCodeSet = allChildren.stream().map(OrgVo::getOrgCode).collect(Collectors.toSet());
        List orgVoList = allChildren.stream().filter(vo -> orgCodeSet.contains(vo.getOrgCode())).collect(Collectors.toList());
        HashMap<String, LinkedList> orgToChildMap = new HashMap<String, LinkedList>(orgVoList.size());
        for (OrgVo orgVo : orgVoList) {
            LinkedList orgCodeList = Lists.newLinkedList();
            String ruleCode = orgVo.getRuleCode();
            for (OrgVo allChild : allChildren) {
                String childRuleCode = allChild.getRuleCode();
                boolean isStart = childRuleCode.startsWith(ruleCode);
                if (!isStart) continue;
                orgCodeList.add(allChild.getOrgCode());
            }
            orgToChildMap.put(orgVo.getOrgCode(), orgCodeList);
        }
        List orgPositionVos = this.orgPositionVoService.findByOrgCodes((List)Lists.newArrayList(childrenCodeSet));
        if (!CollectionUtils.isEmpty((Collection)orgPositionVos)) {
            orgToPositionMap = orgPositionVos.stream().collect(Collectors.groupingBy(OrgPositionVo::getOrgCode));
            positionCodeSet = orgPositionVos.stream().map(OrgPositionVo::getPositionCode).collect(Collectors.toSet());
        } else {
            orgToPositionMap = Maps.newHashMap();
            positionCodeSet = Sets.newHashSet();
        }
        Set userPositionVos = !CollectionUtils.isEmpty((Collection)positionCodeSet) ? this.userPositionVoService.findByPositionCodeIn((Collection)positionCodeSet) : Sets.newHashSet();
        Map<Object, Object> positionToUserMap = !CollectionUtils.isEmpty((Collection)userPositionVos) ? userPositionVos.stream().collect(Collectors.groupingBy(UserPositionVo::getPositionCode)) : new HashMap(0);
        HashMap<String, Integer> map = new HashMap<String, Integer>(orgCodeSet.size());
        for (Map.Entry entry : orgToChildMap.entrySet()) {
            String orgCode = (String)entry.getKey();
            HashSet userSet = Sets.newHashSet();
            List childOrgCodeList = (List)entry.getValue();
            if (CollectionUtils.isEmpty((Collection)childOrgCodeList)) continue;
            for (String childOrgCode : childOrgCodeList) {
                List orgPositionVoList = (List)orgToPositionMap.get(childOrgCode);
                if (CollectionUtils.isEmpty((Collection)orgPositionVoList)) continue;
                for (OrgPositionVo orgPositionVo : orgPositionVoList) {
                    String positionCode = orgPositionVo.getPositionCode();
                    List userPositionVoList = (List)positionToUserMap.get(positionCode);
                    if (CollectionUtils.isEmpty((Collection)userPositionVoList)) continue;
                    Set userNameSet = userPositionVoList.stream().map(UserPositionVo::getUserName).collect(Collectors.toSet());
                    userSet.addAll(userNameSet);
                }
            }
            map.put(orgCode, userSet.size());
        }
        for (NewsNoticeVo newsNoticeVo : list) {
            Integer integer = (Integer)map.get(newsNoticeVo.getPublishOrgCode());
            newsNoticeVo.setTotalNum(integer);
        }
        return pageResult;
    }

    public Page<NewsNoticeVo> findByNewsNoticeCustomerPageDto(Pageable pageable, NewsNoticeCustomerPageDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        dto = (NewsNoticeCustomerPageDto)ObjectUtils.defaultIfNull((Object)dto, (Object)new NewsNoticeCustomerPageDto());
        dto.setTenantCode(TenantUtils.getTenantCode());
        if (StringUtils.isBlank((CharSequence)dto.getBusinessCode())) {
            this.buildCustomerPageDto((AbstractCustomerPageDto)dto);
        }
        FacturerUserDetails loginDetails = (FacturerUserDetails)this.loginUserService.getLoginDetails(FacturerUserDetails.class);
        dto.setOrgCodeList(Arrays.asList(loginDetails.getOrgCode()));
        Page<NewsNoticeModelVo> entityPage = this.newsNoticeModelRepository.findByNewsNoticeCustomerPageDto(pageable, dto);
        List userlist = this.userPositionVoService.findAllUser(TenantUtils.getTenantCode());
        List alluser = userlist.stream().map(UserPositionVo::getUserName).distinct().collect(Collectors.toList());
        Page pageResult = new Page(entityPage.getCurrent(), entityPage.getSize(), entityPage.getTotal());
        if (CollectionUtils.isEmpty((Collection)entityPage.getRecords())) {
            return pageResult;
        }
        ArrayList list = Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByBlankList((Iterable)entityPage.getRecords(), NewsNoticeModelVo.class, NewsNoticeVo.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        List<String> noticeIds = list.stream().map(UuidVo::getId).collect(Collectors.toList());
        List<Object> recordEntities = new ArrayList();
        recordEntities = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dto.getUserName()}) ? this.newsNoticeReadRecordRepository.findByNewsNoticeIdsAndUserName(noticeIds, dto.getUserName()) : this.newsNoticeReadRecordRepository.findByNewsNoticeIdsAndUserName(noticeIds, this.loginUserService.getLoginAccountName());
        Map<Object, Object> recordEntityMap = Maps.newHashMap();
        if (!CollectionUtils.isEmpty(recordEntities)) {
            recordEntityMap = recordEntities.stream().collect(Collectors.toMap(NewsNoticeReadRecordEntity::getNoticeId, t -> t, (key1, key2) -> key2));
        }
        for (NewsNoticeVo noticeVo : list) {
            noticeVo.setHaveRead(Boolean.valueOf(Objects.nonNull(recordEntityMap.get(noticeVo.getId()))));
        }
        List<NewsNoticeModelVo> newsNoticeModelVos = this.newsNoticeModelRepository.findAllByNewsNoticeCustomer(dto);
        ArrayList newsNoticeVos = Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByBlankList(newsNoticeModelVos, NewsNoticeModelVo.class, NewsNoticeVo.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        List<String> ids = newsNoticeVos.stream().map(UuidVo::getId).collect(Collectors.toList());
        List<Object> newsNoticeReadRecordEntities = new ArrayList();
        newsNoticeReadRecordEntities = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dto.getUserName()}) ? this.newsNoticeReadRecordRepository.findByNewsNoticeIdsAndUserName(ids, dto.getUserName()) : this.newsNoticeReadRecordRepository.findByNewsNoticeIdsAndUserName(ids, this.loginUserService.getLoginAccountName());
        Map<Object, Object> finalRecordEntityMap = Maps.newHashMap();
        if (!CollectionUtils.isEmpty(recordEntities)) {
            finalRecordEntityMap = newsNoticeReadRecordEntities.stream().collect(Collectors.toMap(NewsNoticeReadRecordEntity::getNoticeId, t -> t, (key1, key2) -> key2));
        }
        Integer unreadCount = 0;
        for (NewsNoticeModelVo noticeModelVo : newsNoticeModelVos) {
            if (Objects.nonNull(finalRecordEntityMap.get(noticeModelVo.getId()))) continue;
            Integer n = unreadCount;
            Integer n2 = unreadCount = Integer.valueOf(unreadCount + 1);
        }
        for (NewsNoticeVo noticeVo : list) {
            if (noticeVo.getTotalNum() != null && noticeVo.getTotalNum() != 0) continue;
            noticeVo.setTotalNum(Integer.valueOf(alluser.size()));
        }
        pageResult.setRecords((List)list);
        PageResult pr = new PageResult();
        BeanUtils.copyProperties((Object)pageResult, (Object)((Object)pr));
        pr.setUnreadTotal(unreadCount);
        return pr;
    }

    public NewsNoticeVo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        NewsNoticeEntity entity = this.newsNoticeRepository.findById(id);
        if (Objects.isNull((Object)entity)) {
            return null;
        }
        NewsNoticeVo noticeVo = (NewsNoticeVo)this.nebulaToolkitService.copyObjectByBlankList((Object)entity, NewsNoticeVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        this.perfectScopeInfo(noticeVo.getScopeList());
        return noticeVo;
    }

    @Transactional
    public void create(List<NewsNoticeDto> dtoList) {
        this.createValidation(dtoList);
        AbstractCrmUserIdentity loginDetails = this.loginUserService.getAbstractLoginUser();
        Object orgCodeObject = loginDetails.invokeFieldValue("orgCode");
        Object orgNameObject = loginDetails.invokeFieldValue("orgName");
        List<NewsNoticeEntity> noticeEntities = dtoList.stream().map(dto -> {
            NewsNoticeEntity entity = (NewsNoticeEntity)((Object)((Object)this.nebulaToolkitService.copyObjectByBlankList(dto, NewsNoticeEntity.class, LinkedHashSet.class, ArrayList.class, new String[0])));
            entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            entity.setPublishOrgCode(orgCodeObject == null ? null : orgCodeObject.toString());
            entity.setPublishOrgName(orgNameObject == null ? null : orgNameObject.toString());
            entity.setTenantCode(TenantUtils.getTenantCode());
            return entity;
        }).collect(Collectors.toList());
        this.newsNoticeRepository.saveBatch(noticeEntities);
        this.saveExtInfo(noticeEntities);
    }

    private void saveExtInfo(List<NewsNoticeEntity> noticeEntities) {
        ArrayList noticeScopeEntities = Lists.newArrayList();
        ArrayList noticeFileEntities = Lists.newArrayList();
        noticeEntities.forEach(noticeEntity -> {
            if (!CollectionUtils.isEmpty(noticeEntity.getScopeList())) {
                noticeEntity.getScopeList().forEach(noticeScopeEntity -> {
                    noticeScopeEntity.setTenantCode(TenantUtils.getTenantCode());
                    noticeScopeEntity.setNoticeId(noticeEntity.getId());
                });
                noticeScopeEntities.addAll(noticeEntity.getScopeList());
            }
            if (!CollectionUtils.isEmpty(noticeEntity.getFileList())) {
                noticeEntity.getFileList().forEach(noticeFileEntity -> {
                    noticeFileEntity.setTenantCode(noticeEntity.getTenantCode());
                    noticeFileEntity.setNoticeId(noticeEntity.getId());
                });
                noticeFileEntities.addAll(noticeEntity.getFileList());
            }
        });
        if (!CollectionUtils.isEmpty((Collection)noticeScopeEntities)) {
            this.newsNoticeScopeRepository.saveBatch(noticeScopeEntities);
        }
        if (!CollectionUtils.isEmpty((Collection)noticeFileEntities)) {
            this.newsNoticeFileRepository.saveBatch(noticeFileEntities);
        }
    }

    private void createValidation(List<NewsNoticeDto> dtoList) {
        Validate.isTrue((!CollectionUtils.isEmpty(dtoList) ? 1 : 0) != 0, (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!", (Object[])new Object[0]);
        dtoList.forEach(dto -> {
            dto.setId(null);
            dto.setTenantCode(TenantUtils.getTenantCode());
            Validate.notBlank((CharSequence)dto.getTitle(), (String)"\u7f3a\u5931\u6807\u9898", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)dto.getType(), (String)"\u7f3a\u5931\u7c7b\u578b", (Object[])new Object[0]);
            Validate.notNull((Object)dto.getStartTime(), (String)"\u7f3a\u5931\u751f\u6548\u5f00\u59cb\u65f6\u95f4", (Object[])new Object[0]);
            Validate.notNull((Object)dto.getEndTime(), (String)"\u7f3a\u5931\u751f\u6548\u7ed3\u675f\u65f6\u95f4", (Object[])new Object[0]);
            Validate.isTrue((boolean)dto.getStartTime().before(dto.getEndTime()), (String)"\u751f\u6548\u5f00\u59cb\u65f6\u95f4\u5fc5\u987b\u5c0f\u4e8e\u751f\u6548\u7ed3\u675f\u65f6\u95f4", (Object[])new Object[0]);
            if (!CollectionUtils.isEmpty((Collection)dto.getScopeList())) {
                dto.getScopeList().forEach(noticeScopeDto -> {
                    List scopeTypeList = Arrays.stream(ScopeType.values()).map(Enum::name).collect(Collectors.toList());
                    Validate.isTrue((boolean)scopeTypeList.contains(noticeScopeDto.getScopeType()), (String)"\u4e0d\u652f\u6301\u7684\u8303\u56f4\u7c7b\u578b!", (Object[])new Object[0]);
                });
            }
            Validate.isTrue((dto.getTitle().length() < 128 ? 1 : 0) != 0, (String)"\u6807\u9898\uff0c\u5728\u8fdb\u884c\u7f16\u8f91\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        });
    }
}

