package com.biz.crm.mdm.business.news.notice.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.*;
import java.util.Date;
import java.util.List;


/**
 * 公告实体类
 *
 * @author lww
 * @date 2022/5/12
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "NewsNoticeEntity", description = "公告实体类")
@Entity
@TableName("mdm_news_notice")
@Table(name = "mdm_news_notice", indexes = {
    @Index(name = "mdm_news_notice_index1", columnList = "publish_org_code"),
    @Index(name = "mdm_news_notice_index2", columnList = "tenant_code"),
})
@org.hibernate.annotations.Table(appliesTo = "mdm_news_notice", comment = "公告表")
public class NewsNoticeEntity extends TenantFlagOpEntity {


  private static final long serialVersionUID = 9014755486223607858L;
  /**
   * 标题
   */
  @ApiModelProperty("标题")
  @Column(name = "title", length = 128, columnDefinition = "VARCHAR(128) COMMENT '标题'")
  private String title;

  /**
   * 类型
   */
  @ApiModelProperty("类型")
  @Column(name = "type", length = 10, columnDefinition = "VARCHAR(10) COMMENT '类型'")
  private String type;

  /**
   * 发布部门code
   */
  @ApiModelProperty("发布部门code")
  @Column(name = "publish_org_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '发布部门code'")
  private String publishOrgCode;

  /**
   * 发布部门名称
   */
  @ApiModelProperty("发布部门名称")
  @Column(name = "publish_org_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '发布部门名称'")
  private String publishOrgName;

  /**
   * 生效开始时间
   */
  @ApiModelProperty("生效开始时间")
  @Column(name = "start_time", columnDefinition = "datetime COMMENT '生效开始时间'")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date startTime;


  /**
   * 生效结束时间
   */
  @ApiModelProperty("生效结束时间")
  @Column(name = "end_time", columnDefinition = "datetime COMMENT '生效结束时间'")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date endTime;

  /**
   * 公告内容
   */
  @ApiModelProperty("公告内容")
  @Column(name = "content", columnDefinition = "text COMMENT '公告内容'")
  private String content;

  /**
   * 公告文件关联信息
   */
  @ApiModelProperty("公告文件关联信息")
  @Transient
  @TableField(exist = false)
  private List<NewsNoticeFileEntity> fileList;

  /**
   * 公告范围关联信息
   */
  @ApiModelProperty("公告范围关联信息")
  @Transient
  @TableField(exist = false)
  private List<NewsNoticeScopeEntity> scopeList;

}
