package com.biz.crm.mdm.business.news.notice.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.mdm.business.news.notice.local.entity.NewsNoticeFileEntity;
import com.biz.crm.mdm.business.news.notice.local.mapper.NewsNoticeFileMapper;
import org.springframework.stereotype.Component;

/**
 * 公告文件表的数据库访问类 {@link NewsNoticeFileEntity}
 *
 * @author lww
 * @date 2022/5/12
 */
@Component
public class NewsNoticeFileRepository extends ServiceImpl<NewsNoticeFileMapper, NewsNoticeFileEntity> {

  /**
   * 通过公告ID删除公告文件信息
   *
   * @param noticeId 公告ID
   */
  public void deleteByNoticeId(String noticeId) {
    this.lambdaUpdate()
        .eq(NewsNoticeFileEntity::getNoticeId, noticeId)
        .remove();
  }

}
