package com.biz.crm.mdm.business.news.notice.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.news.notice.local.entity.NewsNoticeEntity;
import com.biz.crm.mdm.business.news.notice.local.mapper.NewsNoticeMapper;

import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 公告表的数据库访问类 {@link NewsNoticeEntity}
 *
 * @author lww
 * @date 2022/5/12
 */
@Component
public class NewsNoticeRepository extends ServiceImpl<NewsNoticeMapper, NewsNoticeEntity> {

  /**
   * 批量删除
   *
   * @param ids ID集合
   */
  public void updateDelFlagByIds(List<String> ids) {
    this.lambdaUpdate()
        .in(NewsNoticeEntity::getId, ids)
        .set(NewsNoticeEntity::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
        .update();
  }

  /**
   * 批量更新启用禁用状态
   *
   * @param ids          ID集合
   * @param enableStatus 启用禁用状态
   */
  public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enableStatus) {
    this.lambdaUpdate()
        .in(NewsNoticeEntity::getId, ids)
        .set(NewsNoticeEntity::getEnableStatus, enableStatus.getCode())
        .update();
  }

  /**
   * 通过ID获取公告信息
   *
   * @param id 公告ID
   * @return 公告信息
   */
  public NewsNoticeEntity findById(String id) {
    return this.baseMapper.findById(id);
  }
}
