/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.news.notice.local.service.internal;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.news.notice.local.entity.NewsNoticeEntity;
import com.biz.crm.mdm.business.news.notice.local.repository.NewsNoticeRepository;
import com.biz.crm.mdm.business.news.notice.local.service.NewsNoticeFileService;
import com.biz.crm.mdm.business.news.notice.local.service.NewsNoticeScopeService;
import com.biz.crm.mdm.business.news.notice.local.service.NewsNoticeService;
import com.biz.crm.mdm.business.news.notice.sdk.dto.NewsNoticeDto;
import com.biz.crm.mdm.business.news.notice.sdk.enums.ScopeType;
import com.biz.crm.mdm.business.news.notice.sdk.event.NewsNoticeEventListener;
import com.biz.crm.mdm.business.news.notice.sdk.vo.NewsNoticeEventVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="noticeService")
public class NewsNoticeServiceImpl
implements NewsNoticeService {
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private NewsNoticeRepository newsNoticeRepository;
    @Autowired(required=false)
    private NewsNoticeFileService newsNoticeFileService;
    @Autowired(required=false)
    private NewsNoticeScopeService newsNoticeScopeService;
    @Autowired(required=false)
    private List<NewsNoticeEventListener> listeners;
    @Autowired(required=false)
    private LoginUserService loginUserService;

    @Override
    @Transactional
    public NewsNoticeEntity create(NewsNoticeDto dto) {
        this.createValidation(dto);
        AbstractCrmUserIdentity loginDetails = this.loginUserService.getAbstractLoginUser();
        NewsNoticeEntity entity = (NewsNoticeEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, NewsNoticeEntity.class, HashSet.class, ArrayList.class, new String[0]));
        entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        Object orgCodeObject = loginDetails.invokeFieldValue("orgCode");
        Object orgNameObject = loginDetails.invokeFieldValue("orgName");
        entity.setPublishOrgCode(orgCodeObject == null ? null : orgCodeObject.toString());
        entity.setPublishOrgName(orgNameObject == null ? null : orgNameObject.toString());
        this.newsNoticeRepository.save((Object)entity);
        this.newsNoticeFileService.update(dto.getFileList(), entity.getId());
        this.newsNoticeScopeService.update(dto.getScopeList(), entity.getId());
        if (!CollectionUtils.isEmpty(this.listeners)) {
            NewsNoticeEventVo vo = (NewsNoticeEventVo)this.nebulaToolkitService.copyObjectByBlankList((Object)entity, NewsNoticeEventVo.class, HashSet.class, ArrayList.class, new String[0]);
            this.listeners.forEach(listener -> listener.onCreate(vo));
        }
        return entity;
    }

    @Override
    @Transactional
    public NewsNoticeEntity update(NewsNoticeDto dto) {
        this.updateValidation(dto);
        NewsNoticeEntity entity = (NewsNoticeEntity)((Object)this.newsNoticeRepository.getById((Serializable)((Object)dto.getId())));
        Validate.notNull((Object)((Object)entity), (String)"\u516c\u544a\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        NewsNoticeEntity updateEntity = (NewsNoticeEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, NewsNoticeEntity.class, HashSet.class, ArrayList.class, new String[0]));
        this.newsNoticeRepository.updateById((Object)updateEntity);
        this.newsNoticeFileService.update(dto.getFileList(), entity.getId());
        this.newsNoticeScopeService.update(dto.getScopeList(), entity.getId());
        if (!CollectionUtils.isEmpty(this.listeners)) {
            NewsNoticeEventVo oldVo = (NewsNoticeEventVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, NewsNoticeEventVo.class, HashSet.class, ArrayList.class, new String[0]);
            NewsNoticeEventVo newVo = (NewsNoticeEventVo)this.nebulaToolkitService.copyObjectByBlankList((Object)dto, NewsNoticeEventVo.class, HashSet.class, ArrayList.class, new String[0]);
            this.listeners.forEach(listener -> listener.onUpdate(oldVo, newVo));
        }
        return updateEntity;
    }

    @Override
    @Transactional
    public void deleteBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u7f3a\u5931id", (Object[])new Object[0]);
        List entities = this.newsNoticeRepository.listByIds(ids);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)entities) && entities.size() == ids.size() ? 1 : 0) != 0, (String)"\u6570\u636e\u5220\u9664\u4e2a\u6570\u4e0d\u5339\u914d", (Object[])new Object[0]);
        this.newsNoticeRepository.updateDelFlagByIds(ids);
        if (!CollectionUtils.isEmpty(this.listeners)) {
            ArrayList voList = Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)entities, NewsNoticeEntity.class, NewsNoticeEventVo.class, HashSet.class, ArrayList.class, new String[0]));
            this.listeners.forEach(listener -> listener.onDelete(voList));
        }
    }

    @Override
    @Transactional
    public void enableBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u7f3a\u5931id", (Object[])new Object[0]);
        List entities = this.newsNoticeRepository.listByIds(ids);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)entities) && entities.size() == ids.size() ? 1 : 0) != 0, (String)"\u6570\u636e\u542f\u7528\u4e2a\u6570\u4e0d\u5339\u914d", (Object[])new Object[0]);
        this.newsNoticeRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
        if (!CollectionUtils.isEmpty(this.listeners)) {
            ArrayList voList = Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)entities, NewsNoticeEntity.class, NewsNoticeEventVo.class, HashSet.class, ArrayList.class, new String[0]));
            this.listeners.forEach(listener -> listener.onEnable(voList));
        }
    }

    @Override
    @Transactional
    public void disableBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u7f3a\u5931id", (Object[])new Object[0]);
        List entities = this.newsNoticeRepository.listByIds(ids);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)entities) && entities.size() == ids.size() ? 1 : 0) != 0, (String)"\u6570\u636e\u7981\u7528\u4e2a\u6570\u4e0d\u5339\u914d", (Object[])new Object[0]);
        this.newsNoticeRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
        if (!CollectionUtils.isEmpty(this.listeners)) {
            ArrayList voList = Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)entities, NewsNoticeEntity.class, NewsNoticeEventVo.class, HashSet.class, ArrayList.class, new String[0]));
            this.listeners.forEach(listener -> listener.onDisable(voList));
        }
    }

    private void createValidation(NewsNoticeDto dto) {
        Validate.notNull((Object)dto, (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!", (Object[])new Object[0]);
        dto.setId(null);
        dto.setTenantCode(TenantUtils.getTenantCode());
        Validate.notBlank((CharSequence)dto.getTitle(), (String)"\u7f3a\u5931\u6807\u9898", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getType(), (String)"\u7f3a\u5931\u7c7b\u578b", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getStartTime(), (String)"\u7f3a\u5931\u751f\u6548\u5f00\u59cb\u65f6\u95f4", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getEndTime(), (String)"\u7f3a\u5931\u751f\u6548\u7ed3\u675f\u65f6\u95f4", (Object[])new Object[0]);
        Validate.isTrue((boolean)dto.getStartTime().before(dto.getEndTime()), (String)"\u751f\u6548\u5f00\u59cb\u65f6\u95f4\u5fc5\u987b\u5c0f\u4e8e\u751f\u6548\u7ed3\u675f\u65f6\u95f4", (Object[])new Object[0]);
        if (!CollectionUtils.isEmpty((Collection)dto.getScopeList())) {
            dto.getScopeList().forEach(noticeScopeDto -> {
                List scopeTypeList = Arrays.stream(ScopeType.values()).map(Enum::name).collect(Collectors.toList());
                Validate.isTrue((boolean)scopeTypeList.contains(noticeScopeDto.getScopeType()), (String)"\u4e0d\u652f\u6301\u7684\u8303\u56f4\u7c7b\u578b!", (Object[])new Object[0]);
            });
        }
        Validate.isTrue((dto.getTitle().length() < 128 ? 1 : 0) != 0, (String)"\u6807\u9898\uff0c\u5728\u8fdb\u884c\u7f16\u8f91\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    private void updateValidation(NewsNoticeDto dto) {
        Validate.notNull((Object)dto, (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!", (Object[])new Object[0]);
        dto.setTenantCode(TenantUtils.getTenantCode());
        Validate.notBlank((CharSequence)dto.getId(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0cid\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getTitle(), (String)"\u7f3a\u5931\u6807\u9898", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getType(), (String)"\u7f3a\u5931\u7c7b\u578b", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getStartTime(), (String)"\u7f3a\u5931\u751f\u6548\u5f00\u59cb\u65f6\u95f4", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getEndTime(), (String)"\u7f3a\u5931\u751f\u6548\u7ed3\u675f\u65f6\u95f4", (Object[])new Object[0]);
        Validate.isTrue((boolean)dto.getStartTime().before(dto.getEndTime()), (String)"\u751f\u6548\u5f00\u59cb\u65f6\u95f4\u5fc5\u987b\u5c0f\u4e8e\u751f\u6548\u7ed3\u675f\u65f6\u95f4", (Object[])new Object[0]);
        if (!CollectionUtils.isEmpty((Collection)dto.getScopeList())) {
            dto.getScopeList().forEach(noticeScopeDto -> {
                List scopeTypeList = Arrays.stream(ScopeType.values()).map(Enum::name).collect(Collectors.toList());
                Validate.isTrue((boolean)scopeTypeList.contains(noticeScopeDto.getScopeType()), (String)"\u4e0d\u652f\u6301\u7684\u8303\u56f4\u7c7b\u578b!", (Object[])new Object[0]);
            });
        }
        Validate.isTrue((dto.getTitle().length() < 128 ? 1 : 0) != 0, (String)"\u6807\u9898\uff0c\u5728\u8fdb\u884c\u7f16\u8f91\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }
}

