package com.biz.crm.mdm.business.news.notice.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.news.notice.local.service.NewsNoticeService;
import com.biz.crm.mdm.business.news.notice.sdk.dto.NewsNoticeDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 消息公告: NewsNotice:公告管理
 *
 * @author lww
 * @date 2022/5/13
 */
@Slf4j
@RestController
@RequestMapping("/v1/newsnotice/newsnotice")
@Api(tags = "消息公告: NewsNotice: 公告管理")
public class NewsNoticeController {

  @Autowired(required = false)
  private NewsNoticeService newsNoticeService;

  /**
   * 新增公告信息
   *
   * @param dto 参数dto
   * @return 新增公告数据
   */
  @ApiOperation(value = "新增公告")
  @PostMapping("")
  public Result<?> create(@RequestBody NewsNoticeDto dto) {
    try {
      return Result.ok(this.newsNoticeService.create(dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 更新公告信息
   *
   * @param dto 参数dto
   * @return 更新后公告数据
   */
  @ApiOperation(value = "更新公告信息")
  @PatchMapping("")
  public Result<?> update(@RequestBody NewsNoticeDto dto) {
    try {
      return Result.ok(this.newsNoticeService.update(dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 删除公告
   *
   * @param ids 公告id集合
   * @return 操作结果
   */
  @ApiOperation(value = "删除")
  @DeleteMapping("/deleteBatch")
  public Result<?> deleteBatch(@RequestParam("ids") List<String> ids) {
    try {
      this.newsNoticeService.deleteBatch(ids);
      return Result.ok("删除成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 启用公告
   *
   * @param ids 公告id集合
   * @return 操作结果
   */
  @ApiOperation(value = "启用")
  @PatchMapping("/enableBatch")
  public Result<?> enableBatch(@RequestBody List<String> ids) {
    try {
      this.newsNoticeService.enableBatch(ids);
      return Result.ok("启用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 禁用公告
   *
   * @param ids 公告id集合
   * @return 操作结果
   */
  @ApiOperation(value = "禁用")
  @PatchMapping("/disableBatch")
  public Result<?> disableBatch(@RequestBody List<String> ids) {
    try {
      this.newsNoticeService.disableBatch(ids);
      return Result.ok("禁用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
