package com.biz.crm.mdm.business.news.notice.local.mapper;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.news.notice.local.model.NewsNoticeModelVo;
import com.biz.crm.mdm.business.news.notice.sdk.dto.NewsNoticeCustomerPageDto;
import com.biz.crm.mdm.business.news.notice.sdk.dto.NewsNoticePageDto;
import org.apache.ibatis.annotations.Param;

/**
 * 公告内部模板的mybatis-plus接口类
 *
 * @author lww
 * @date 2022/5/13
 */
public interface NewsNoticeModelMapper {

  /**
   * 公告分页列表
   *
   * @param page 分页信息
   * @param dto  分页参数dto
   * @return 分页列表
   */
  Page<NewsNoticeModelVo> findByConditions(Page<NewsNoticeModelVo> page, @Param("dto") NewsNoticePageDto dto);

  /**
   * 客户-公告分页列表
   *
   * @param page 分页信息
   * @param dto  分页参数dto
   * @return 分页列表
   */
  Page<NewsNoticeModelVo> findByNewsNoticeCustomerPageDto(Page<NewsNoticeModelVo> page, @Param("dto") NewsNoticeCustomerPageDto dto);

}

