package com.biz.crm.mdm.business.news.notice.local.repository;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.news.notice.local.mapper.NewsNoticeModelMapper;
import com.biz.crm.mdm.business.news.notice.local.model.NewsNoticeModelVo;
import com.biz.crm.mdm.business.news.notice.sdk.dto.NewsNoticeCustomerPageDto;
import com.biz.crm.mdm.business.news.notice.sdk.dto.NewsNoticePageDto;
import com.bizunited.nebula.common.util.tenant.TenantUtils;

/**
 * 公告内部模板数据库访问类
 *
 * @author lww
 * @date 2022/5/12
 */
@Component
public class NewsNoticeModelRepository {

  @Autowired(required = false)
  private NewsNoticeModelMapper newsNoticeModelMapper;

  /**
   * 公告分页列表
   *
   * @param pageable 分页信息
   * @param dto  分页参数dto
   * @return Page<NewsNoticeModelVo> 分页列表
   */
  public Page<NewsNoticeModelVo> findByConditions(Pageable pageable, NewsNoticePageDto dto) {
    Page<NewsNoticeModelVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    dto.setTenantCode(TenantUtils.getTenantCode());
    return this.newsNoticeModelMapper.findByConditions(page, dto);
  }

  /**
   * 客户-公告分页列表
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<NewsNoticeEntity>公告分页信息
   */
  public Page<NewsNoticeModelVo> findByNewsNoticeCustomerPageDto(Pageable pageable, NewsNoticeCustomerPageDto dto) {
    Page<NewsNoticeModelVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    dto.setTenantCode(TenantUtils.getTenantCode());
    return this.newsNoticeModelMapper.findByNewsNoticeCustomerPageDto(page, dto);
  }
}
