package com.biz.crm.mdm.business.news.notice.local.model;

import com.baomidou.mybatisplus.annotation.TableField;
import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.biz.crm.mdm.business.news.notice.local.entity.NewsNoticeFileEntity;
import com.biz.crm.mdm.business.news.notice.local.entity.NewsNoticeScopeEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Transient;
import java.util.Date;
import java.util.List;

/**
 * 公告信息内部模板Vo
 *
 * @author lww
 * @date 2022/5/12
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
public class NewsNoticeModelVo extends TenantFlagOpVo {

  private static final long serialVersionUID = -2866667033914345129L;
  /**
   * 标题
   */
  @ApiModelProperty(value = "标题")
  private String title;
  /**
   * 类型
   */
  @ApiModelProperty(value = "类型")
  private String type;
  /**
   * 生效开始时间
   */
  @ApiModelProperty("生效开始时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date startTime;
  /**
   * 生效结束时间
   */
  @ApiModelProperty("生效结束时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date endTime;
  /**
   * 公告内容
   */
  @ApiModelProperty(value = "公告内容")
  private String content;
  /**
   * 发布部门code
   */
  @ApiModelProperty(value = "发布部门code")
  private String publishOrgCode;
  /**
   * 发布部门名称
   */
  @ApiModelProperty(value = "发布部门名称")
  private String publishOrgName;
  /**
   * 公告状态(0:待开始,1:进行中,2:已结束)
   */
  @ApiModelProperty(value = "公告状态(0:待开始,1:进行中,2:已结束)")
  private String noticeState;
  /**
   * 访问人数
   */
  @ApiModelProperty("访问人数")
  private Integer visitNum;
  /**
   * 总人数
   */
  @ApiModelProperty("总人数")
  private Integer totalNum;
  /**
   * 总用户数
   */
  @ApiModelProperty(value = "总用户数")
  private Integer allUser;
  /**
   * 是否已阅读(true:已阅读,false:未阅读)
   */
  @ApiModelProperty("是否已阅读(true:已阅读,false:未阅读)")
  private Boolean haveRead;

  /**
   * 公告文件关联信息
   */
  @ApiModelProperty("公告文件关联信息")
  @Transient
  @TableField(exist = false)
  private List<NewsNoticeFileEntity> fileList;

  /**
   * 公告范围关联信息
   */
  @ApiModelProperty("公告范围关联信息")
  @Transient
  @TableField(exist = false)
  private List<NewsNoticeScopeEntity> scopeList;
}
