package com.biz.crm.mdm.business.news.notice.local.repository;

import org.springframework.stereotype.Component;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.mdm.business.news.notice.local.entity.NewsNoticeFileEntity;
import com.biz.crm.mdm.business.news.notice.local.mapper.NewsNoticeFileMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;

/**
 * 公告文件表的数据库访问类 {@link NewsNoticeFileEntity}
 *
 * @author lww
 * @date 2022/5/12
 */
@Component
public class NewsNoticeFileRepository extends ServiceImpl<NewsNoticeFileMapper, NewsNoticeFileEntity> {

  /**
   * 通过公告ID删除公告文件信息
   *
   * @param noticeId 公告ID
   */
  public void deleteByNoticeId(String noticeId) {
    this.lambdaUpdate()
        .eq(NewsNoticeFileEntity::getNoticeId, noticeId)
        .eq(NewsNoticeFileEntity::getTenantCode, TenantUtils.getTenantCode()) // 增加租户控制
        .remove();
  }

}
