package com.biz.crm.mdm.business.news.notice.local.repository;

import java.util.List;
import org.springframework.stereotype.Component;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.news.notice.local.entity.NewsNoticeEntity;
import com.biz.crm.mdm.business.news.notice.local.mapper.NewsNoticeMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;

/**
 * 公告表的数据库访问类 {@link NewsNoticeEntity}
 *
 * @author lww
 * @date 2022/5/12
 */
@Component
public class NewsNoticeRepository extends ServiceImpl<NewsNoticeMapper, NewsNoticeEntity> {

  /**
   * 批量删除
   *
   * @param ids ID集合
   */
  public void updateDelFlagByIds(List<String> ids) {
    this.lambdaUpdate()
        .in(NewsNoticeEntity::getId, ids)
        .set(NewsNoticeEntity::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
        .eq(NewsNoticeEntity::getTenantCode, TenantUtils.getTenantCode()) // 增加租户控制
        .update();
  }

  /**
   * 批量更新启用禁用状态
   *
   * @param ids          ID集合
   * @param enableStatus 启用禁用状态
   */
  public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enableStatus) {
    this.lambdaUpdate()
        .in(NewsNoticeEntity::getId, ids)
        .set(NewsNoticeEntity::getEnableStatus, enableStatus.getCode())
        .eq(NewsNoticeEntity::getTenantCode, TenantUtils.getTenantCode()) // 增加租户控制
        .update();
  }

  /**
   * 通过ID获取公告信息
   *
   * @param id 公告ID
   * @return 公告信息
   */
  public NewsNoticeEntity findById(String id) {
     return this.baseMapper.findById(id, TenantUtils.getTenantCode());
  }

  /**
   *
   * @param id
   * @param tenantCode
   * @return
   */
  public NewsNoticeEntity findByIdAndTenantCode(String id, String tenantCode) {
    return this.lambdaQuery()
        .eq(NewsNoticeEntity::getTenantCode,tenantCode)
        .in(NewsNoticeEntity::getId,id)
        .one();
  }

  public List<NewsNoticeEntity> listByIdsAndTenantCode(List<String> ids, String tenantCode) {
    return this.lambdaQuery()
        .eq(NewsNoticeEntity::getTenantCode,tenantCode)
        .in(NewsNoticeEntity::getId,ids)
        .list();
  }
}
