package com.biz.crm.mdm.business.news.notice.local.service;

import com.biz.crm.mdm.business.news.notice.local.entity.NewsNoticeEntity;
import com.biz.crm.mdm.business.news.notice.sdk.dto.NewsNoticeDto;

import java.util.List;

/**
 * 公告表服务接口
 *
 * @author lww
 * @date 2022/5/12
 */
public interface NewsNoticeService {

  /**
   * 创建公告
   *
   * @param dto 参数dto
   * @return 创建的公告
   */
  NewsNoticeEntity create(NewsNoticeDto dto);

  /**
   * 更新公告
   *
   * @param dto 参数dto
   * @return 更新的公告
   */
  NewsNoticeEntity update(NewsNoticeDto dto);

  /**
   * 批量删除公告
   *
   * @param ids 公告id集合
   */
  void deleteBatch(List<String> ids);

  /**
   * 批量启用公告
   *
   * @param ids 公告id集合
   */
  void enableBatch(List<String> ids);

  /**
   * 批量禁用公告
   *
   * @param ids 公告id集合
   */
  void disableBatch(List<String> ids);

}
