package com.biz.crm.mdm.business.news.notice.local.service.internal;

import com.biz.crm.mdm.business.news.notice.local.entity.NewsNoticeFileEntity;
import com.biz.crm.mdm.business.news.notice.local.repository.NewsNoticeFileRepository;
import com.biz.crm.mdm.business.news.notice.local.service.NewsNoticeFileService;
import com.biz.crm.mdm.business.news.notice.sdk.dto.base.NewsFileDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;

import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * 公告文件表服务实现类
 *
 * @author lww
 * @date 2022/5/13
 */
@Service("noticeFileService")
public class NewsNoticeFileServiceImpl implements NewsNoticeFileService {

  @Autowired(required = false)
  private NewsNoticeFileRepository noticeFileRepository;
  @Autowired(required = false)
  @Qualifier("nebulaToolkitService")
  private NebulaToolkitService nebulaToolkitService;

  @Override
  @Transactional
  public void update(List<NewsFileDto> dtoList, String noticeId) {
    Validate.notBlank(noticeId, "公告ID不能为空");
    this.noticeFileRepository.deleteByNoticeId(noticeId);
    if (CollectionUtils.isEmpty(dtoList)) {
      return;
    }
    String tenantCode = TenantUtils.getTenantCode();
    //过滤无效的数据
    List<NewsNoticeFileEntity> entities = dtoList.stream()
        .filter(Objects::nonNull)
        .map(dto -> {
          NewsNoticeFileEntity entity = this.nebulaToolkitService.copyObjectByWhiteList(dto, NewsNoticeFileEntity.class, HashSet.class, ArrayList.class);
          entity.setNoticeId(noticeId);
          entity.setTenantCode(tenantCode);
          entity.setSortNum(dtoList.indexOf(dto));
          entity.setOriginalFileName(dto.getOriginalFileName());
          return entity;
        }).collect(Collectors.toList());
    if (CollectionUtils.isEmpty(entities)) {
      return;
    }
    this.noticeFileRepository.saveBatch(entities);
  }
}
