package com.biz.crm.mdm.business.news.notice.local.service.internal;

import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.news.notice.local.entity.NewsNoticeReadRecordEntity;
import com.biz.crm.mdm.business.news.notice.local.repository.NewsNoticeReadRecordRepository;
import com.biz.crm.mdm.business.news.notice.local.service.NewsNoticeReadRecordService;
import com.biz.crm.mdm.business.news.notice.local.service.NewsNoticeService;
import com.biz.crm.mdm.business.news.notice.sdk.dto.NewsNoticeReadRecordDto;

import com.bizunited.nebula.common.util.tenant.TenantUtils;

import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import java.util.List;

/**
 * 公告阅读记录表服务实现类
 *
 * @author lww
 * @date 2022/5/13
 */
@Slf4j
@Service("noticeReadRecordService")
public class NewsNoticeReadRecordServiceImpl implements NewsNoticeReadRecordService {

  @Autowired(required = false)
  private NewsNoticeReadRecordRepository newsNoticeReadRecordRepository;

  @Autowired(required = false)
  private LoginUserService loginUserService;

  @Autowired
  private NewsNoticeService newsNoticeService;

  @Override
  @Transactional
  public List<NewsNoticeReadRecordEntity> create(NewsNoticeReadRecordDto dto) {
    Validate.notNull(dto, "进行当前操作时，信息对象必须传入!");
    dto.setId(null);
    dto.setTenantCode(TenantUtils.getTenantCode());
    AbstractCrmUserIdentity loginDetails = loginUserService.getAbstractLoginUser();
    Validate.isTrue(!ObjectUtils.isEmpty(loginDetails),"没有登录信息");
    dto.setUserName(loginDetails.getAccount());
    Validate.notBlank(dto.getUserName(), "缺失用户名");
    Validate.notBlank(dto.getNoticeId().get(0), "缺失公告ID");
    List<NewsNoticeReadRecordEntity> recordEntity = this.newsNoticeReadRecordRepository.findByNewsNoticeIdsAndUserName(dto.getNoticeId(), dto.getUserName());
    if (!CollectionUtils.isEmpty(recordEntity)) {
      log.info("该用户已经阅读了此公告!");
      return recordEntity;
    }
    /*//阅读完后修改主表状态--未做删除
    newsNoticeService.disableBatch(dto.getNoticeId());*/
    for(String a:dto.getNoticeId()){
      NewsNoticeReadRecordEntity b =new NewsNoticeReadRecordEntity();
      b.setNoticeId(a);
      b.setUserName(dto.getUserName());
      b.setTenantCode(TenantUtils.getTenantCode());
      this.newsNoticeReadRecordRepository.save(b);
    }
    return recordEntity;
  }
}
