/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.news.notice.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.news.notice.local.service.NewsNoticeService;
import com.biz.crm.mdm.business.news.notice.sdk.dto.NewsNoticeDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/newsnotice/newsnotice"})
@Api(tags={"\u6d88\u606f\u516c\u544a: NewsNotice: \u516c\u544a\u7ba1\u7406"})
public class NewsNoticeController {
    private static final Logger log = LoggerFactory.getLogger(NewsNoticeController.class);
    @Autowired(required=false)
    private NewsNoticeService newsNoticeService;

    @ApiOperation(value="\u65b0\u589e\u516c\u544a")
    @PostMapping(value={""})
    public Result<?> create(@RequestBody NewsNoticeDto dto) {
        try {
            return Result.ok((Object)((Object)this.newsNoticeService.create(dto)));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u66f4\u65b0\u516c\u544a\u4fe1\u606f")
    @PatchMapping(value={""})
    public Result<?> update(@RequestBody NewsNoticeDto dto) {
        try {
            return Result.ok((Object)((Object)this.newsNoticeService.update(dto)));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5220\u9664")
    @DeleteMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(value="ids") List<String> ids) {
        try {
            this.newsNoticeService.deleteBatch(ids);
            return Result.ok((String)"\u5220\u9664\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u542f\u7528")
    @PatchMapping(value={"/enableBatch"})
    public Result<?> enableBatch(@RequestBody List<String> ids) {
        try {
            this.newsNoticeService.enableBatch(ids);
            return Result.ok((String)"\u542f\u7528\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7981\u7528")
    @PatchMapping(value={"/disableBatch"})
    public Result<?> disableBatch(@RequestBody List<String> ids) {
        try {
            this.newsNoticeService.disableBatch(ids);
            return Result.ok((String)"\u7981\u7528\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

