/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.news.notice.local.service.internal;

import com.biz.crm.mdm.business.news.notice.local.entity.NewsNoticeFileEntity;
import com.biz.crm.mdm.business.news.notice.local.repository.NewsNoticeFileRepository;
import com.biz.crm.mdm.business.news.notice.local.service.NewsNoticeFileService;
import com.biz.crm.mdm.business.news.notice.sdk.dto.base.NewsFileDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="noticeFileService")
public class NewsNoticeFileServiceImpl
implements NewsNoticeFileService {
    @Autowired(required=false)
    private NewsNoticeFileRepository noticeFileRepository;
    @Autowired(required=false)
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;

    @Override
    @Transactional
    public void update(List<NewsFileDto> dtoList, String noticeId) {
        Validate.notBlank((CharSequence)noticeId, (String)"\u516c\u544aID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.noticeFileRepository.deleteByNoticeId(noticeId);
        if (CollectionUtils.isEmpty(dtoList)) {
            return;
        }
        String tenantCode = TenantUtils.getTenantCode();
        List entities = dtoList.stream().filter(Objects::nonNull).map(dto -> {
            NewsNoticeFileEntity entity = (NewsNoticeFileEntity)((Object)((Object)this.nebulaToolkitService.copyObjectByWhiteList(dto, NewsNoticeFileEntity.class, HashSet.class, ArrayList.class, new String[0])));
            entity.setNoticeId(noticeId);
            entity.setTenantCode(tenantCode);
            entity.setSortNum(dtoList.indexOf(dto));
            entity.setOriginalFileName(dto.getOriginalFileName());
            return entity;
        }).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(entities)) {
            return;
        }
        this.noticeFileRepository.saveBatch(entities);
    }
}

