/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.news.notice.local.service.internal;

import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.news.notice.local.entity.NewsNoticeReadRecordEntity;
import com.biz.crm.mdm.business.news.notice.local.repository.NewsNoticeReadRecordRepository;
import com.biz.crm.mdm.business.news.notice.local.service.NewsNoticeReadRecordService;
import com.biz.crm.mdm.business.news.notice.local.service.NewsNoticeService;
import com.biz.crm.mdm.business.news.notice.sdk.dto.NewsNoticeReadRecordDto;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service(value="noticeReadRecordService")
public class NewsNoticeReadRecordServiceImpl
implements NewsNoticeReadRecordService {
    private static final Logger log = LoggerFactory.getLogger(NewsNoticeReadRecordServiceImpl.class);
    @Autowired(required=false)
    private NewsNoticeReadRecordRepository newsNoticeReadRecordRepository;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired
    private NewsNoticeService newsNoticeService;

    @Override
    @Transactional
    public List<NewsNoticeReadRecordEntity> create(NewsNoticeReadRecordDto dto) {
        Validate.notNull((Object)dto, (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!", (Object[])new Object[0]);
        dto.setId(null);
        dto.setTenantCode(TenantUtils.getTenantCode());
        AbstractCrmUserIdentity loginDetails = this.loginUserService.getAbstractLoginUser();
        Validate.isTrue((!ObjectUtils.isEmpty((Object)loginDetails) ? 1 : 0) != 0, (String)"\u6ca1\u6709\u767b\u5f55\u4fe1\u606f", (Object[])new Object[0]);
        dto.setUserName(loginDetails.getAccount());
        Validate.notBlank((CharSequence)dto.getUserName(), (String)"\u7f3a\u5931\u7528\u6237\u540d", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)((CharSequence)dto.getNoticeId().get(0)), (String)"\u7f3a\u5931\u516c\u544aID", (Object[])new Object[0]);
        List<NewsNoticeReadRecordEntity> recordEntity = this.newsNoticeReadRecordRepository.findByNewsNoticeIdsAndUserName(dto.getNoticeId(), dto.getUserName());
        if (!CollectionUtils.isEmpty(recordEntity)) {
            log.info("\u8be5\u7528\u6237\u5df2\u7ecf\u9605\u8bfb\u4e86\u6b64\u516c\u544a!");
            return recordEntity;
        }
        for (String a : dto.getNoticeId()) {
            NewsNoticeReadRecordEntity b = new NewsNoticeReadRecordEntity();
            b.setNoticeId(a);
            b.setUserName(dto.getUserName());
            b.setTenantCode(TenantUtils.getTenantCode());
            this.newsNoticeReadRecordRepository.save((Object)b);
        }
        return recordEntity;
    }
}

