package com.biz.crm.mdm.business.news.notice.sdk.dto;

import com.biz.crm.mdm.business.news.notice.sdk.dto.base.AbstractCustomerPageDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 客户-公告分页查询Dto
 *
 * @author lww
 * @date 2022/5/12
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "NoticeCustomerPageDto", description = "客户-公告分页查询Dto")
public class NewsNoticeCustomerPageDto extends AbstractCustomerPageDto {

  /**
   * 标题
   */
  @ApiModelProperty("标题")
  private String title;

  /**
   * 类型
   */
  @ApiModelProperty("类型")
  private String type;

  /**
   * 发布部门名称
   */
  @ApiModelProperty(value = "发布部门名称")
  private String publishOrgName;

  /** 可以查看的账号,未传的话就是查所有的 */
  @ApiModelProperty(value = "可以查看的账号")
  private String businessCode;
}
