package com.biz.crm.mdm.business.news.notice.sdk.dto.base;

import com.biz.crm.business.common.sdk.dto.TenantDto;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.util.List;

/**
 * 抽象客户分页请求dto
 *
 * @author lww
 * @date 2022/5/13
 */
@Data
@EqualsAndHashCode(callSuper = false)
public abstract class AbstractCustomerPageDto extends TenantDto {

  /**
   * 用户名
   */
  @ApiModelProperty(value = "用户名")
  private String userName;
  /**
   * 组织编码集合
   */
  @ApiModelProperty(value = "组织编码集合")
  private List<String> orgCodeList;

  @ApiModelProperty(value = "范围编码")
  private List<String> scopeCodeList;

  /**
   * 客户渠道
   */
  @ApiModelProperty(value = "客户渠道")
  private String channel;
  /**
   * 客户编码
   */
  @ApiModelProperty(value = "客户编码")
  private String customerCode;
}
