package com.biz.crm.mdm.business.news.notice.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 公告信息阅读记录Dto
 *
 * @author lww
 * @date 2022/5/12
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "NoticeReadRecordDto", description = "公告信息阅读记录Dto")
public class NewsNoticeReadRecordDto extends TenantDto {

  /**
   * 用户名
   */
  @ApiModelProperty(value = "用户名")
  private String userName;

  /**
   * 公告ID
   */
  @ApiModelProperty(value = "公告ID")
  private List<String> noticeId;
}
