package com.biz.crm.mdm.business.news.notice.sdk.event;

import com.biz.crm.mdm.business.news.notice.sdk.vo.NewsNoticeEventVo;
import java.util.List;

/**
 * 公告变更事件通知接口
 *
 * @author lww
 * @date 2022/5/12
 */
public interface NewsNoticeEventListener {

  /**
   * 当公告创建时触发
   *
   * @param vo 创建时的vo
   */
  void onCreate(NewsNoticeEventVo vo);

  /**
   * 当公告修改时触发
   *
   * @param oldVo 修改之前的vo
   * @param newVo 修改之后的vo
   */
  void onUpdate(NewsNoticeEventVo oldVo, NewsNoticeEventVo newVo);

  /**
   * 当公告禁用时触发
   *
   * @param voList 禁用vo信息
   */
  void onDisable(List<NewsNoticeEventVo> voList);

  /**
   * 当公告启用时触发
   *
   * @param voList 禁用vo信息
   */
  void onEnable(List<NewsNoticeEventVo> voList);

  /**
   * 当公告删除时触发
   *
   * @param voList 删除vo信息
   */
  void onDelete(List<NewsNoticeEventVo> voList);
}
