package com.biz.crm.mdm.business.news.notice.sdk.vo.base;

import com.biz.crm.business.common.sdk.vo.TenantVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

/**
 * 范围信息Vo
 *
 * @author lww
 * @date 2022/5/12
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ScopeVo", description = "范围信息Vo")
public class ScopeVo extends TenantVo {

  private static final long serialVersionUID = 2128199265379378733L;
  /**
   * 范围编码
   */
  @ApiModelProperty("范围编码")
  private String scopeCode;

  /**
   * 范围名称
   */
  @ApiModelProperty("范围名称")
  private String scopeName;

  /**
   * 是否包含(true: 包含,false:不包含)
   */
  @ApiModelProperty("是否包含(true: 包含,false:不包含)")
  private Boolean containFlag;

  /**
   * 范围类型(ORG:组织范围,CHANNEL:渠道范围,CUSTOMER:客户范围)
   */
  @ApiModelProperty("范围类型(ORG:组织范围,CHANNEL:渠道范围,CUSTOMER:客户范围)")
  private String scopeType;
}
