package com.biz.crm.mdm.business.org.feign.feign;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.org.feign.feign.internal.OrgRegionVoFeignImpl;
import com.biz.crm.mdm.business.org.sdk.vo.OrgRegionVo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 组织行政区域feign
 *
 * @author sunx
 * @date 2021/11/16
 */
@FeignClient(
    name = "${mdm.feign-client.name:crm-mdm}",
    path = "crm-mdm",
    fallbackFactory = OrgRegionVoFeignImpl.class)
public interface OrgRegionVoFeign {

  /**
   * 查询组织关联的行政区域列表（不分页）
   *
   * @param orgCode
   * @return
   */
  @GetMapping("/v1/org/orgRegion/findByOrgCode")
  Result<List<OrgRegionVo>> findByOrgCode(@RequestParam("orgCode") String orgCode);
}
