package com.biz.crm.mdm.business.org.feign.feign;

import antlr.debug.SemanticPredicateEvent;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.org.feign.feign.internal.OrgVoFeignImpl;
import com.biz.crm.mdm.business.org.sdk.dto.OrgQueryDto;
import com.biz.crm.mdm.business.org.sdk.dto.RelateOrgCodeQueryDto;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import java.util.Map;
import java.util.Set;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 组织基本信息feign
 * @author sunx
 */
@FeignClient(
    name = "${mdm.feign-client.name:crm-mdm}",
    path = "crm-mdm",
    fallbackFactory = OrgVoFeignImpl.class)
public interface OrgVoFeign {

  /**
   * 根据组织编码查询全部上级（含当前）组织列表
   *
   * @param orgCode
   * @return
   */
  @GetMapping("/v1/org/org/findAllParentByOrgCode")
  Result<List<OrgVo>> findAllParentByOrgCode(@RequestParam("orgCode") String orgCode);

  /**
   * 按orgCode集合查询
   *
   * @param orgCodeList
   * @return
   */
  @GetMapping(value = {"/v1/org/org/findByOrgCodes"})
  Result<List<OrgVo>> findByOrgCodes(@RequestParam("orgCodeList") List<String> orgCodeList);

  /**
   * 根据组织编码集合查询全部上级（含当前）组织列表
   *
   * @param orgCodes
   * @return
   */
  @GetMapping(value = {"/v1/org/org/findAllParentByOrgCodes"})
  Result<List<OrgVo>> findAllParentByOrgCodes(@RequestParam("orgCodes") List<String> orgCodes);

  /**
   * 查询指定orgCode下的所有子节点
   *
   * @param orgCode
   * @return
   */
  @GetMapping(value = {"/v1/org/org/findAllChildrenByOrgCode"})
  Result<List<OrgVo>> findAllChildrenByOrgCode(@RequestParam("orgCode") String orgCode);

  /**
   * 获取组织编码
   *
   * @param dto
   * @return
   */
  @GetMapping(value = {"/v1/org/org/findByOrgQueryDto"})
  Result<Set<String>> findByOrgQueryDto(@SpringQueryMap OrgQueryDto dto);

  /**
   * 根据获取组织对应的未删除的上级或下级编码
   *
   * @param dto
   * @return
   */
  @GetMapping(value = {"/v1/org/org/findByRelateOrgCodeQueryDto"})
  Result<Map<String,String>> findByRelateOrgCodeQueryDto(@SpringQueryMap RelateOrgCodeQueryDto dto);

  /**
   * 根据销售组织编码批量查询
   *
   * @author huojia
   * @date 2022/12/23 16:28
   * @param salesOrgCodeList
   * @return com.biz.crm.business.common.sdk.model.Result<java.util.List<com.biz.crm.mdm.business.org.sdk.vo.OrgVo>>
   **/
  @PostMapping(value = {"/v1/org/org/findBySalesOrgCodes"})
  Result<List<OrgVo>> findBySalesOrgCodes(@RequestBody List<String> salesOrgCodeList);
}