package com.biz.crm.mdm.business.org.feign.service.internal;

import com.biz.crm.mdm.business.org.feign.feign.OrgPositionVoFeign;
import com.biz.crm.mdm.business.org.sdk.service.OrgPositionVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgPositionVo;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Set;

/**
 * 组织基本信息sdk实现
 * @author pengxi
 */
@Service
public class OrgPositionVoServiceImpl implements OrgPositionVoService {

  @Autowired(required = false)
  private OrgPositionVoFeign orgPositionVoFeign;

  @Override
  public OrgVo findByPositionCode(String positionCode) {
    return this.orgPositionVoFeign.findByPositionCode(positionCode).getResult();
  }

  @Override
  public Set<String> findPositionCodesByOrgCodes(List<String> orgCodes) {
    throw new UnsupportedOperationException();
  }

  @Override
  public List<OrgPositionVo> findByPositionCodes(List<String> positionCodes) {
    return this.orgPositionVoFeign.findByPositionCodes(positionCodes).getResult();
  }

  @Override
  public List<OrgPositionVo> findByOrgCodes(List<String> orgCodes) {
    return this.orgPositionVoFeign.findByOrgCodes(orgCodes).getResult();
  }
}
